---
title: Customization
description: Customize the illustrations to match your brand.
summary: Learn how to tailor Tabler Illustrations by adjusting colors, sizes, and formats. This section provides insights into seamlessly integrating illustrations to align with your design and branding.
---

{% capture html -%}
<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 800 600">
  <path
    d="M165.042 305.17C165.042 347.031 209.306 377.394 228.857 411.189C249.036 446.056 253.885 499.359 288.752 519.524C322.562 539.075 370.673 517.207 412.534 517.207C454.395 517.207 502.506 539.075 536.301 519.524C571.168 499.359 576.017 446.056 596.196 411.189C615.747 377.394 660.011 347.031 660.011 305.17C660.011 263.309 615.747 232.961 596.196 199.166C576.017 164.298 571.168 110.996 536.301 90.8302C502.506 71.2798 454.381 93.1471 412.534 93.1471C370.687 93.1471 322.562 71.2798 288.752 90.8302C253.885 110.996 249.036 164.298 228.857 199.166C209.306 232.961 165.042 263.323 165.042 305.17Z"
    fill="#F7F8FC"
    class="tblr-illustrations-computer-fix-a"
  />
  <path
    d="M375.492 479.923C470.481 479.923 547.485 476.824 547.485 473.001C547.485 469.178 470.481 466.079 375.492 466.079C280.503 466.079 203.5 469.178 203.5 473.001C203.5 476.824 280.503 479.923 375.492 479.923Z"
    fill="#A6A9B3"
    class="tblr-illustrations-computer-fix-b"
  />
  <path
    d="M511.988 174.667C493.855 167.122 474.216 163.9 454.624 165.256L456.64 177.084L511.988 174.667Z"
    fill="#0455A4"
    style="fill: #0455a4; fill: var(--tblr-illustrations-primary, var(--tblr-primary, #0455a4))"
  />
  <path
    d="M518.452 301.638L572.584 329.197L591.949 299.006L602.918 281.844C608.639 272.891 617.062 260.034 627.674 244.159C626.096 241.199 624.176 238.434 621.954 235.921C616.989 230.419 610.739 226.233 603.762 223.736H603.633C599.858 222.306 595.996 221.019 592.192 219.674C585.755 217.369 579.457 214.695 573.328 211.665C568.623 209.377 563.545 206.66 558.154 203.428C555.15 210.807 552.161 218.187 549.187 225.567C543.466 239.868 537.697 254.132 531.881 268.357C527.419 279.465 522.943 290.558 518.452 301.638Z"
    fill="#DADBE0"
  />
  <path
    d="M573.328 211.665L580.908 225.338L581.866 225.567C589.204 227.065 596.817 226.429 603.805 223.736H603.676C599.9 222.306 596.039 221.019 592.235 219.674C585.784 217.371 579.471 214.697 573.328 211.665Z"
    fill="#FFCB9D"
    style="fill: #ffcb9d; fill: var(--tblr-illustrations-skin, #ffcb9d)"
  />
  <path
    d="M627.674 244.216C617.062 260.091 608.696 272.948 602.918 281.901C601.087 284.762 599.757 286.807 594.509 295.016L591.949 299.006L582.738 313.308L572.584 329.14L518.466 301.623C522.928 290.563 527.405 279.494 531.896 268.415L549.186 225.638C549.286 225.409 549.372 225.181 549.472 224.966C551.379 220.132 553.329 215.303 555.322 210.478C556.275 208.152 557.229 205.816 558.182 203.471C561.171 205.287 564.089 206.917 566.878 208.405C569.109 209.606 571.268 210.707 573.356 211.737C579.485 214.732 585.778 217.377 592.206 219.66C596.01 221.004 599.872 222.234 603.647 223.722H603.776C604.648 224.079 605.521 224.423 606.365 224.823C612.359 227.307 617.709 231.121 622.011 235.978C624.209 238.497 626.11 241.261 627.674 244.216Z"
    fill="#0455A4"
    style="fill: #0455a4; fill: var(--tblr-illustrations-primary, var(--tblr-primary, #0455a4))"
  />
  <path
    d="M600.816 220.246C592.321 224.537 585.441 224.852 580.507 224.165C580.221 224.165 579.95 224.094 579.678 224.036L572.069 212.595C578.204 212.59 584.3 213.555 590.132 215.455C593.844 216.693 597.423 218.298 600.816 220.246Z"
    fill="#FFCB9D"
    style="fill: #ffcb9d; fill: var(--tblr-illustrations-skin, #ffcb9d)"
  />
  <path
    d="M191.729 429.895L559.226 429.895C571.011 429.895 580.564 420.342 580.564 408.557V198.408C580.564 186.623 571.011 177.07 559.226 177.07L191.729 177.07C179.945 177.07 170.391 186.623 170.391 198.408V408.557C170.391 420.342 179.945 429.895 191.729 429.895Z"
    fill="white"
    class="tblr-illustrations-computer-fix-c"
  />
  <path
    d="M585.585 197.736C585.395 190.871 582.538 184.35 577.619 179.557C572.701 174.764 566.108 172.076 559.241 172.064H191.687C184.702 172.072 178.006 174.849 173.067 179.788C168.128 184.727 165.35 191.423 165.343 198.408V408.643C165.35 415.628 168.128 422.324 173.067 427.263C178.006 432.201 184.702 434.979 191.687 434.987H326.008V443.94C324.578 453.679 318.042 456.425 313.466 457.126H262.537C261.503 457.13 260.512 457.542 259.781 458.274C259.049 459.005 258.637 459.996 258.633 461.03V465.55C258.637 466.584 259.049 467.575 259.781 468.306C260.512 469.038 261.503 469.45 262.537 469.454H488.504C489.017 469.454 489.525 469.353 489.999 469.157C490.472 468.961 490.903 468.673 491.265 468.31C491.628 467.948 491.915 467.517 492.112 467.044C492.308 466.57 492.409 466.062 492.409 465.55V461.03C492.409 460.517 492.308 460.01 492.112 459.536C491.915 459.062 491.628 458.632 491.265 458.269C490.903 457.907 490.472 457.619 489.999 457.423C489.525 457.227 489.017 457.126 488.504 457.126H437.476C432.899 456.425 426.306 453.665 424.933 443.868V434.915H559.241C566.226 434.908 572.924 432.13 577.865 427.192C582.806 422.254 585.587 415.557 585.599 408.571V198.336C585.599 198.179 585.599 197.964 585.585 197.736ZM575.573 408.571C575.57 412.898 573.849 417.047 570.79 420.106C567.73 423.166 563.582 424.886 559.255 424.89H191.701C187.374 424.886 183.226 423.166 180.166 420.106C177.107 417.047 175.386 412.898 175.383 408.571V198.336C175.386 194.01 177.107 189.861 180.166 186.802C183.226 183.742 187.374 182.022 191.701 182.018H559.255C561.484 182.012 563.691 182.469 565.734 183.362C568.656 184.626 571.144 186.717 572.892 189.378C574.641 192.039 575.573 195.153 575.573 198.336V408.571Z"
    fill="#232B41"
    class="tblr-illustrations-computer-fix-d"
  />
  <path
    d="M211.108 222.706L443.454 222.706C444.497 222.706 445.342 221.861 445.342 220.819V214.798C445.342 213.755 444.497 212.91 443.454 212.91L211.108 212.91C210.066 212.91 209.22 213.755 209.22 214.798V220.819C209.22 221.861 210.066 222.706 211.108 222.706Z"
    fill="#0455A4"
    style="fill: #0455a4; fill: var(--tblr-illustrations-primary, var(--tblr-primary, #0455a4))"
  />
  <path
    d="M211.094 314.981H252.111C253.146 314.981 253.985 314.142 253.985 313.108V307.058C253.985 306.023 253.146 305.184 252.111 305.184H211.094C210.059 305.184 209.22 306.023 209.22 307.058V313.108C209.22 314.142 210.059 314.981 211.094 314.981Z"
    fill="#DADBE0"
  />
  <path
    d="M211.809 279.856H368.97C370.4 279.856 371.559 278.697 371.559 277.267V250.595C371.559 249.165 370.4 248.006 368.97 248.006L211.809 248.006C210.379 248.006 209.22 249.165 209.22 250.595V277.267C209.22 278.697 210.379 279.856 211.809 279.856Z"
    fill="#A7AAB3"
  />
  <path
    d="M389.479 335.733L382.271 326.78L363.822 341.611L346.56 320.144L331.586 332.2L348.848 353.667L330.399 368.498L337.593 377.465L356.042 362.62L373.304 384.087L388.292 372.031L371.03 350.564L389.479 335.733Z"
    fill="#0455A4"
    style="fill: #0455a4; fill: var(--tblr-illustrations-primary, var(--tblr-primary, #0455a4))"
  />
  <path
    d="M591.934 268.701C593.522 258.689 602.961 233.776 606.393 224.895C605.55 224.494 604.677 224.151 603.805 223.793H603.676C597.784 223.936 594.695 223.45 594.451 222.363C594.266 221.548 595.567 220.418 598.356 218.945C595.969 217.727 593.498 216.68 590.962 215.813C589.216 215.204 587.44 214.684 585.642 214.254L585.413 309.389C587.615 305.957 589.818 302.539 592.006 299.106L594.566 295.116C592.635 286.034 590.919 275.094 591.934 268.701ZM485.401 254.857C484.8 254.942 484.114 259.376 486.288 262.208C486.835 262.909 487.534 263.476 488.333 263.867C487.189 258.861 486.002 254.785 485.401 254.857ZM507.354 307.487C505.774 306.55 504.119 305.747 502.406 305.084C503.966 306.056 505.625 306.862 507.354 307.487ZM469.283 332.115L465.765 355.569L469.583 349.491C469.14 343.71 469.039 337.908 469.283 332.115ZM514.004 331.385C514.763 329.722 515.32 327.975 515.663 326.179C506.08 322.786 496.693 318.861 487.546 314.423C485.44 321.176 482.706 327.717 479.38 333.959L469.583 349.534C469.755 351.293 469.984 353.038 470.298 354.711C472.043 364.122 476.219 370.586 479.408 375.535C485.661 385.147 494.013 393.215 503.836 399.132C530.306 400.116 556.093 390.607 575.588 372.674V364.994L514.004 331.385Z"
    fill="black"
    opacity="0.1"
  />
  <path
    d="M514.376 314.638C512.764 311.667 510.325 309.227 507.354 307.616C505.625 306.99 503.966 306.185 502.406 305.213L502.148 305.084C502.148 305.084 502.248 305.084 502.406 305.213C504.119 305.875 505.774 306.679 507.354 307.616C507.997 307.787 508.527 307.802 508.784 307.53C510.1 306.243 503.478 300.451 502.005 290.783C501.633 288.251 500.761 282.502 504.05 277.182C508.169 270.517 515.935 269.244 517.422 269.015C511.358 267.019 505.07 265.785 498.701 265.34C494.411 265.039 490.835 265.182 488.318 263.91C489.348 268.372 490.349 273.549 490.864 277.153C492.515 289.684 491.377 302.426 487.532 314.466C496.679 318.904 506.065 322.829 515.649 326.222C516.477 322.324 516.031 318.263 514.376 314.638ZM585.584 175.096V229.042C582.59 228.905 579.63 228.351 576.789 227.397C565.562 223.564 557.567 213.668 557.567 202.069C557.567 190.47 565.562 180.616 576.789 176.741C579.63 175.787 582.59 175.233 585.584 175.096Z"
    fill="black"
    opacity="0.1"
  />
  <path
    d="M585.57 222.935L609.483 216.128L613.501 223.278L588.974 239.868C587.816 237.194 586.643 234.505 585.484 231.817C585.556 228.827 585.556 225.967 585.57 222.935Z"
    fill="#DADBE0"
  />
  <path
    d="M585.584 175.096V229.042C582.59 228.905 579.63 228.351 576.789 227.397L575.559 226.954V198.351C575.558 195.167 574.626 192.053 572.878 189.392C571.13 186.732 568.641 184.641 565.719 183.377C568.431 180.786 571.61 178.733 575.087 177.327C575.645 177.098 576.217 176.884 576.789 176.683C579.633 175.749 582.593 175.215 585.584 175.096Z"
    fill="black"
    opacity="0.3"
  />
  <path
    d="M610.198 137.454C611.056 141.973 612.186 148.609 613.358 156.818C613.587 158.62 613.816 160.194 613.902 160.737C614.881 169.779 614.722 178.908 613.43 187.91C613.144 189.698 612.843 191.4 612.429 193.073C611.299 197.707 600.287 205.258 587.072 209.706C582.519 211.261 577.817 212.34 573.042 212.924C558.182 214.712 548.414 204.586 548.343 195.762C548.293 193.608 548.896 191.488 550.073 189.684C552.13 186.006 553.496 181.983 554.106 177.813C555.126 172.287 555.748 166.695 555.966 161.08C556.166 157.877 556.151 155.789 556.151 155.789L567.593 140.214L601.845 132.348C602.761 138.197 605.178 141.844 607.066 141.787C608.953 141.73 609.955 138.212 610.198 137.454Z"
    fill="#FFCB9D"
    style="fill: #ffcb9d; fill: var(--tblr-illustrations-skin, #ffcb9d)"
  />
  <path
    d="M610.198 137.454C611.041 141.973 612.185 148.609 613.373 156.818C613.587 158.62 613.816 160.208 613.887 160.737C614.877 169.778 614.728 178.907 613.444 187.91C611.07 187.716 608.754 187.071 606.622 186.008C604.293 184.813 602.223 183.171 600.53 181.174C598.789 179.022 597.399 176.608 596.411 174.023C595.671 172.382 595.036 170.696 594.509 168.975C582.401 176.336 568.178 179.433 554.106 177.77C555.126 172.244 555.747 166.652 555.965 161.037C556.166 157.834 556.151 155.731 556.151 155.731L567.593 140.171L601.845 132.348C602.761 138.197 605.178 141.844 607.065 141.773C608.953 141.701 610.026 138.212 610.269 137.482"
    fill="black"
    opacity="0.1"
  />
  <path
    d="M616.147 143.804C617.621 150.946 616.333 158.382 612.543 164.613C611.699 165.705 610.934 166.857 610.255 168.059C608.586 171.497 607.8 175.297 607.967 179.115C605.963 177.555 604.47 175.434 603.676 173.022C602.575 169.318 602.618 161.996 602.475 161.009V160.408C602.475 160.079 602.389 159.636 602.275 158.778C601.977 156.941 601.562 155.126 601.03 153.343C601.023 153.249 600.988 153.16 600.93 153.086C593.479 160.322 571.769 178.829 552.304 169.962C549.27 168.595 546.452 166.793 543.938 164.613C543.696 164.444 543.479 164.242 543.294 164.012C542.682 163.466 542.104 162.884 541.564 162.267L541.406 162.11C540.013 160.506 538.892 158.685 538.088 156.718L537.488 155.889C537.211 155.006 537.005 154.102 536.873 153.186C536.555 149.566 537.5 145.948 539.547 142.946C543.251 137.068 549.701 132.62 553.105 130.303C566.291 121.136 588.001 114.728 603.505 124.983C607.42 127.703 610.643 131.303 612.915 135.494C614.324 138.117 615.359 140.923 615.99 143.832"
    fill="#232B41"
    class="tblr-illustrations-computer-fix-d"
  />
  <path
    d="M600.744 153.028C593.293 160.265 571.583 178.771 552.118 169.904C549.084 168.538 546.266 166.736 543.752 164.556C543.51 164.387 543.293 164.185 543.108 163.955C542.496 163.409 541.918 162.827 541.378 162.21L541.22 162.053C539.83 160.447 538.709 158.626 537.902 156.661C542.634 159.548 547.809 161.635 553.219 162.839C580.007 168.674 602.146 148.724 605.678 145.534L605.95 145.291C604.428 148.012 602.707 150.618 600.801 153.086"
    fill="black"
    opacity="0.5"
  />
  <path
    d="M483.942 177.727C483.944 179.167 483.81 180.604 483.542 182.018H457.484C457.216 180.604 457.082 179.167 457.083 177.727C457.072 175.8 457.298 173.879 457.756 172.007H483.284C483.729 173.881 483.95 175.801 483.942 177.727Z"
    fill="black"
    opacity="0.3"
  />
  <path
    d="M466.422 169.089C467.695 170.426 468.769 171.938 469.612 173.58C472.744 179.386 472.315 185.679 468.053 189.169C462.618 193.559 453.165 191.729 446.872 185.064C446.186 184.326 445.55 183.543 444.97 182.719C440.493 176.412 440.451 168.875 445.256 164.999C450.633 160.594 460.144 162.425 466.422 169.089Z"
    fill="#FFCB9D"
    style="fill: #ffcb9d; fill: var(--tblr-illustrations-skin, #ffcb9d)"
  />
  <path
    d="M466.422 169.089C467.695 170.426 468.769 171.938 469.612 173.58C469.011 173.98 468.468 174.338 467.881 174.695C460.144 179.344 455.167 178.385 446.114 182.161C445.722 182.324 445.34 182.51 444.97 182.719C440.493 176.412 440.451 168.875 445.256 164.999C450.633 160.594 460.144 162.425 466.422 169.089Z"
    fill="black"
    opacity="0.1"
  />
  <path
    d="M585.599 343.37V364.122L575.587 372.703V346.831L585.384 342.212L585.599 343.37Z"
    fill="black"
    opacity="0.15"
  />
  <path
    d="M520.025 263.695C518.559 268.03 515.781 271.802 512.076 274.488C508.37 277.173 503.921 278.64 499.345 278.683L483.141 326.766L476.205 347.274L473.273 355.927C476.717 358.617 479.284 362.269 480.65 366.42C482.016 370.571 482.119 375.034 480.946 379.243C479.772 383.452 477.376 387.219 474.059 390.064C470.743 392.91 466.657 394.707 462.318 395.228L469.04 375.377C469.299 374.598 469.24 373.747 468.876 373.011C468.512 372.274 467.872 371.711 467.095 371.444L454.967 367.34C454.187 367.08 453.337 367.139 452.6 367.503C451.864 367.867 451.301 368.508 451.034 369.285L444.326 389.135C441.191 386.09 439.031 382.181 438.122 377.905C437.212 373.629 437.594 369.179 439.219 365.121C440.843 361.063 443.637 357.579 447.246 355.112C450.855 352.644 455.115 351.305 459.486 351.265L462.347 342.941L469.412 322.046L485.573 274.021C482.129 271.331 479.561 267.679 478.195 263.528C476.829 259.377 476.726 254.914 477.9 250.705C479.073 246.495 481.47 242.729 484.786 239.883C488.102 237.038 492.189 235.24 496.528 234.72L489.806 254.571C489.673 254.956 489.619 255.365 489.645 255.772C489.671 256.179 489.778 256.577 489.959 256.942C490.14 257.308 490.391 257.634 490.699 257.902C491.006 258.17 491.364 258.375 491.751 258.504L503.864 262.608C504.644 262.868 505.494 262.809 506.231 262.445C506.967 262.08 507.53 261.44 507.797 260.663L514.519 240.812C517.507 243.715 519.611 247.406 520.585 251.457C521.56 255.507 521.366 259.751 520.025 263.695Z"
    fill="#A7AAB3"
  />
  <path
    d="M483.141 326.766L476.205 347.274C473.637 346.92 471.106 346.341 468.639 345.544C466.472 344.831 464.359 343.961 462.318 342.941L469.383 322.046C471.541 322.405 473.668 322.926 475.747 323.605C478.306 324.422 480.782 325.48 483.141 326.766Z"
    fill="black"
    opacity="0.1"
  />
  <path
    d="M477.421 302.581C474.667 302.666 471.941 303.148 469.326 304.012C459.915 306.872 453.765 314.023 454.638 322.175C455.782 332.544 467.738 340.524 481.396 340.052C482.907 339.986 484.412 339.823 485.901 339.566C497.257 337.549 505.209 329.555 504.179 320.459C503.063 310.147 491.05 302.11 477.421 302.581Z"
    fill="#FFCB9D"
    style="fill: #ffcb9d; fill: var(--tblr-illustrations-skin, #ffcb9d)"
  />
  <path
    d="M477.42 302.581C474.667 302.666 471.941 303.148 469.326 304.012C469.555 305.07 469.755 306.014 470.012 307.001C473.344 320.058 479.623 324.263 485.244 337.764C485.499 338.35 485.719 338.952 485.901 339.566C497.257 337.549 505.209 329.555 504.179 320.459C503.063 310.147 491.05 302.11 477.42 302.581Z"
    fill="black"
    opacity="0.1"
  />
  <path
    d="M640.36 287.951C638.93 310.59 624.628 332.93 601.002 350.178C579.177 366.095 549.387 377.694 514.391 381.184C508.167 370.155 502.23 358.967 496.585 347.632C494.726 343.928 492.909 340.181 491.079 336.362C483.928 321.46 477.664 307.044 472.129 293.271C487.689 298.377 551.975 318.442 589.932 302.152C596.811 299.206 610.541 293.4 612.486 282.13C613.048 278.08 612.317 273.956 610.398 270.345C608.798 267.347 607.829 264.053 607.55 260.666C607.271 257.279 607.688 253.871 608.776 250.652C609.864 247.432 611.599 244.469 613.876 241.946C616.152 239.422 618.92 237.392 622.011 235.978C640.46 260.177 640.861 279.87 640.36 287.951Z"
    fill="#0455A4"
    style="fill: #0455a4; fill: var(--tblr-illustrations-primary, var(--tblr-primary, #0455a4))"
  />
  <path
    d="M601.002 350.178C579.177 366.095 549.387 377.694 514.39 381.184C511.347 375.792 508.372 370.361 505.466 364.894C501.376 357.2 497.519 349.634 493.896 342.197C505.942 349.292 519.121 354.256 532.854 356.871C555.749 361.042 579.355 358.723 601.002 350.178Z"
    fill="black"
    opacity="0.1"
  />
</svg>
{%- endcapture %}
{% include "docs/example.html" html=html %}

## Color of the illustration

You can change the color of the illustration by setting the `--tblr-illustrations-primary` CSS variable to the desired color. This will change the color of the primary elements in the illustration.

```html
<div style="--tblr-illustrations-primary: #cc0000">
  <svg>...</svg>
</div>
```

You can customize it globally by setting the variable on the `body` element or locally by setting it on a parent element.

```css
body {
--tblr-illustrations-primary: #CC0000;
}
```

{% capture html -%}
<div style="--tblr-illustrations-primary: #cc0000">
  <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 800 600">
    <path
      d="M165.042 305.17C165.042 347.031 209.306 377.394 228.857 411.189C249.036 446.056 253.885 499.359 288.752 519.524C322.562 539.075 370.673 517.207 412.534 517.207C454.395 517.207 502.506 539.075 536.301 519.524C571.168 499.359 576.017 446.056 596.196 411.189C615.747 377.394 660.011 347.031 660.011 305.17C660.011 263.309 615.747 232.961 596.196 199.166C576.017 164.298 571.168 110.996 536.301 90.8302C502.506 71.2798 454.381 93.1471 412.534 93.1471C370.687 93.1471 322.562 71.2798 288.752 90.8302C253.885 110.996 249.036 164.298 228.857 199.166C209.306 232.961 165.042 263.323 165.042 305.17Z"
      fill="#F7F8FC"
      class="tblr-illustrations-computer-fix-a"
    />
    <path
      d="M375.492 479.923C470.481 479.923 547.485 476.824 547.485 473.001C547.485 469.178 470.481 466.079 375.492 466.079C280.503 466.079 203.5 469.178 203.5 473.001C203.5 476.824 280.503 479.923 375.492 479.923Z"
      fill="#A6A9B3"
      class="tblr-illustrations-computer-fix-b"
    />
    <path
      d="M511.988 174.667C493.855 167.122 474.216 163.9 454.624 165.256L456.64 177.084L511.988 174.667Z"
      fill="#0455A4"
      style="fill: #0455a4; fill: var(--tblr-illustrations-primary, var(--tblr-primary, #0455a4))"
    />
    <path
      d="M518.452 301.638L572.584 329.197L591.949 299.006L602.918 281.844C608.639 272.891 617.062 260.034 627.674 244.159C626.096 241.199 624.176 238.434 621.954 235.921C616.989 230.419 610.739 226.233 603.762 223.736H603.633C599.858 222.306 595.996 221.019 592.192 219.674C585.755 217.369 579.457 214.695 573.328 211.665C568.623 209.377 563.545 206.66 558.154 203.428C555.15 210.807 552.161 218.187 549.187 225.567C543.466 239.868 537.697 254.132 531.881 268.357C527.419 279.465 522.943 290.558 518.452 301.638Z"
      fill="#DADBE0"
    />
    <path
      d="M573.328 211.665L580.908 225.338L581.866 225.567C589.204 227.065 596.817 226.429 603.805 223.736H603.676C599.9 222.306 596.039 221.019 592.235 219.674C585.784 217.371 579.471 214.697 573.328 211.665Z"
      fill="#FFCB9D"
      style="fill: #ffcb9d; fill: var(--tblr-illustrations-skin, #ffcb9d)"
    />
    <path
      d="M627.674 244.216C617.062 260.091 608.696 272.948 602.918 281.901C601.087 284.762 599.757 286.807 594.509 295.016L591.949 299.006L582.738 313.308L572.584 329.14L518.466 301.623C522.928 290.563 527.405 279.494 531.896 268.415L549.186 225.638C549.286 225.409 549.372 225.181 549.472 224.966C551.379 220.132 553.329 215.303 555.322 210.478C556.275 208.152 557.229 205.816 558.182 203.471C561.171 205.287 564.089 206.917 566.878 208.405C569.109 209.606 571.268 210.707 573.356 211.737C579.485 214.732 585.778 217.377 592.206 219.66C596.01 221.004 599.872 222.234 603.647 223.722H603.776C604.648 224.079 605.521 224.423 606.365 224.823C612.359 227.307 617.709 231.121 622.011 235.978C624.209 238.497 626.11 241.261 627.674 244.216Z"
      fill="#0455A4"
      style="fill: #0455a4; fill: var(--tblr-illustrations-primary, var(--tblr-primary, #0455a4))"
    />
    <path
      d="M600.816 220.246C592.321 224.537 585.441 224.852 580.507 224.165C580.221 224.165 579.95 224.094 579.678 224.036L572.069 212.595C578.204 212.59 584.3 213.555 590.132 215.455C593.844 216.693 597.423 218.298 600.816 220.246Z"
      fill="#FFCB9D"
      style="fill: #ffcb9d; fill: var(--tblr-illustrations-skin, #ffcb9d)"
    />
    <path
      d="M191.729 429.895L559.226 429.895C571.011 429.895 580.564 420.342 580.564 408.557V198.408C580.564 186.623 571.011 177.07 559.226 177.07L191.729 177.07C179.945 177.07 170.391 186.623 170.391 198.408V408.557C170.391 420.342 179.945 429.895 191.729 429.895Z"
      fill="white"
      class="tblr-illustrations-computer-fix-c"
    />
    <path
      d="M585.585 197.736C585.395 190.871 582.538 184.35 577.619 179.557C572.701 174.764 566.108 172.076 559.241 172.064H191.687C184.702 172.072 178.006 174.849 173.067 179.788C168.128 184.727 165.35 191.423 165.343 198.408V408.643C165.35 415.628 168.128 422.324 173.067 427.263C178.006 432.201 184.702 434.979 191.687 434.987H326.008V443.94C324.578 453.679 318.042 456.425 313.466 457.126H262.537C261.503 457.13 260.512 457.542 259.781 458.274C259.049 459.005 258.637 459.996 258.633 461.03V465.55C258.637 466.584 259.049 467.575 259.781 468.306C260.512 469.038 261.503 469.45 262.537 469.454H488.504C489.017 469.454 489.525 469.353 489.999 469.157C490.472 468.961 490.903 468.673 491.265 468.31C491.628 467.948 491.915 467.517 492.112 467.044C492.308 466.57 492.409 466.062 492.409 465.55V461.03C492.409 460.517 492.308 460.01 492.112 459.536C491.915 459.062 491.628 458.632 491.265 458.269C490.903 457.907 490.472 457.619 489.999 457.423C489.525 457.227 489.017 457.126 488.504 457.126H437.476C432.899 456.425 426.306 453.665 424.933 443.868V434.915H559.241C566.226 434.908 572.924 432.13 577.865 427.192C582.806 422.254 585.587 415.557 585.599 408.571V198.336C585.599 198.179 585.599 197.964 585.585 197.736ZM575.573 408.571C575.57 412.898 573.849 417.047 570.79 420.106C567.73 423.166 563.582 424.886 559.255 424.89H191.701C187.374 424.886 183.226 423.166 180.166 420.106C177.107 417.047 175.386 412.898 175.383 408.571V198.336C175.386 194.01 177.107 189.861 180.166 186.802C183.226 183.742 187.374 182.022 191.701 182.018H559.255C561.484 182.012 563.691 182.469 565.734 183.362C568.656 184.626 571.144 186.717 572.892 189.378C574.641 192.039 575.573 195.153 575.573 198.336V408.571Z"
      fill="#232B41"
      class="tblr-illustrations-computer-fix-d"
    />
    <path
      d="M211.108 222.706L443.454 222.706C444.497 222.706 445.342 221.861 445.342 220.819V214.798C445.342 213.755 444.497 212.91 443.454 212.91L211.108 212.91C210.066 212.91 209.22 213.755 209.22 214.798V220.819C209.22 221.861 210.066 222.706 211.108 222.706Z"
      fill="#0455A4"
      style="fill: #0455a4; fill: var(--tblr-illustrations-primary, var(--tblr-primary, #0455a4))"
    />
    <path
      d="M211.094 314.981H252.111C253.146 314.981 253.985 314.142 253.985 313.108V307.058C253.985 306.023 253.146 305.184 252.111 305.184H211.094C210.059 305.184 209.22 306.023 209.22 307.058V313.108C209.22 314.142 210.059 314.981 211.094 314.981Z"
      fill="#DADBE0"
    />
    <path
      d="M211.809 279.856H368.97C370.4 279.856 371.559 278.697 371.559 277.267V250.595C371.559 249.165 370.4 248.006 368.97 248.006L211.809 248.006C210.379 248.006 209.22 249.165 209.22 250.595V277.267C209.22 278.697 210.379 279.856 211.809 279.856Z"
      fill="#A7AAB3"
    />
    <path
      d="M389.479 335.733L382.271 326.78L363.822 341.611L346.56 320.144L331.586 332.2L348.848 353.667L330.399 368.498L337.593 377.465L356.042 362.62L373.304 384.087L388.292 372.031L371.03 350.564L389.479 335.733Z"
      fill="#0455A4"
      style="fill: #0455a4; fill: var(--tblr-illustrations-primary, var(--tblr-primary, #0455a4))"
    />
    <path
      d="M591.934 268.701C593.522 258.689 602.961 233.776 606.393 224.895C605.55 224.494 604.677 224.151 603.805 223.793H603.676C597.784 223.936 594.695 223.45 594.451 222.363C594.266 221.548 595.567 220.418 598.356 218.945C595.969 217.727 593.498 216.68 590.962 215.813C589.216 215.204 587.44 214.684 585.642 214.254L585.413 309.389C587.615 305.957 589.818 302.539 592.006 299.106L594.566 295.116C592.635 286.034 590.919 275.094 591.934 268.701ZM485.401 254.857C484.8 254.942 484.114 259.376 486.288 262.208C486.835 262.909 487.534 263.476 488.333 263.867C487.189 258.861 486.002 254.785 485.401 254.857ZM507.354 307.487C505.774 306.55 504.119 305.747 502.406 305.084C503.966 306.056 505.625 306.862 507.354 307.487ZM469.283 332.115L465.765 355.569L469.583 349.491C469.14 343.71 469.039 337.908 469.283 332.115ZM514.004 331.385C514.763 329.722 515.32 327.975 515.663 326.179C506.08 322.786 496.693 318.861 487.546 314.423C485.44 321.176 482.706 327.717 479.38 333.959L469.583 349.534C469.755 351.293 469.984 353.038 470.298 354.711C472.043 364.122 476.219 370.586 479.408 375.535C485.661 385.147 494.013 393.215 503.836 399.132C530.306 400.116 556.093 390.607 575.588 372.674V364.994L514.004 331.385Z"
      fill="black"
      opacity="0.1"
    />
    <path
      d="M514.376 314.638C512.764 311.667 510.325 309.227 507.354 307.616C505.625 306.99 503.966 306.185 502.406 305.213L502.148 305.084C502.148 305.084 502.248 305.084 502.406 305.213C504.119 305.875 505.774 306.679 507.354 307.616C507.997 307.787 508.527 307.802 508.784 307.53C510.1 306.243 503.478 300.451 502.005 290.783C501.633 288.251 500.761 282.502 504.05 277.182C508.169 270.517 515.935 269.244 517.422 269.015C511.358 267.019 505.07 265.785 498.701 265.34C494.411 265.039 490.835 265.182 488.318 263.91C489.348 268.372 490.349 273.549 490.864 277.153C492.515 289.684 491.377 302.426 487.532 314.466C496.679 318.904 506.065 322.829 515.649 326.222C516.477 322.324 516.031 318.263 514.376 314.638ZM585.584 175.096V229.042C582.59 228.905 579.63 228.351 576.789 227.397C565.562 223.564 557.567 213.668 557.567 202.069C557.567 190.47 565.562 180.616 576.789 176.741C579.63 175.787 582.59 175.233 585.584 175.096Z"
      fill="black"
      opacity="0.1"
    />
    <path
      d="M585.57 222.935L609.483 216.128L613.501 223.278L588.974 239.868C587.816 237.194 586.643 234.505 585.484 231.817C585.556 228.827 585.556 225.967 585.57 222.935Z"
      fill="#DADBE0"
    />
    <path
      d="M585.584 175.096V229.042C582.59 228.905 579.63 228.351 576.789 227.397L575.559 226.954V198.351C575.558 195.167 574.626 192.053 572.878 189.392C571.13 186.732 568.641 184.641 565.719 183.377C568.431 180.786 571.61 178.733 575.087 177.327C575.645 177.098 576.217 176.884 576.789 176.683C579.633 175.749 582.593 175.215 585.584 175.096Z"
      fill="black"
      opacity="0.3"
    />
    <path
      d="M610.198 137.454C611.056 141.973 612.186 148.609 613.358 156.818C613.587 158.62 613.816 160.194 613.902 160.737C614.881 169.779 614.722 178.908 613.43 187.91C613.144 189.698 612.843 191.4 612.429 193.073C611.299 197.707 600.287 205.258 587.072 209.706C582.519 211.261 577.817 212.34 573.042 212.924C558.182 214.712 548.414 204.586 548.343 195.762C548.293 193.608 548.896 191.488 550.073 189.684C552.13 186.006 553.496 181.983 554.106 177.813C555.126 172.287 555.748 166.695 555.966 161.08C556.166 157.877 556.151 155.789 556.151 155.789L567.593 140.214L601.845 132.348C602.761 138.197 605.178 141.844 607.066 141.787C608.953 141.73 609.955 138.212 610.198 137.454Z"
      fill="#FFCB9D"
      style="fill: #ffcb9d; fill: var(--tblr-illustrations-skin, #ffcb9d)"
    />
    <path
      d="M610.198 137.454C611.041 141.973 612.185 148.609 613.373 156.818C613.587 158.62 613.816 160.208 613.887 160.737C614.877 169.778 614.728 178.907 613.444 187.91C611.07 187.716 608.754 187.071 606.622 186.008C604.293 184.813 602.223 183.171 600.53 181.174C598.789 179.022 597.399 176.608 596.411 174.023C595.671 172.382 595.036 170.696 594.509 168.975C582.401 176.336 568.178 179.433 554.106 177.77C555.126 172.244 555.747 166.652 555.965 161.037C556.166 157.834 556.151 155.731 556.151 155.731L567.593 140.171L601.845 132.348C602.761 138.197 605.178 141.844 607.065 141.773C608.953 141.701 610.026 138.212 610.269 137.482"
      fill="black"
      opacity="0.1"
    />
    <path
      d="M616.147 143.804C617.621 150.946 616.333 158.382 612.543 164.613C611.699 165.705 610.934 166.857 610.255 168.059C608.586 171.497 607.8 175.297 607.967 179.115C605.963 177.555 604.47 175.434 603.676 173.022C602.575 169.318 602.618 161.996 602.475 161.009V160.408C602.475 160.079 602.389 159.636 602.275 158.778C601.977 156.941 601.562 155.126 601.03 153.343C601.023 153.249 600.988 153.16 600.93 153.086C593.479 160.322 571.769 178.829 552.304 169.962C549.27 168.595 546.452 166.793 543.938 164.613C543.696 164.444 543.479 164.242 543.294 164.012C542.682 163.466 542.104 162.884 541.564 162.267L541.406 162.11C540.013 160.506 538.892 158.685 538.088 156.718L537.488 155.889C537.211 155.006 537.005 154.102 536.873 153.186C536.555 149.566 537.5 145.948 539.547 142.946C543.251 137.068 549.701 132.62 553.105 130.303C566.291 121.136 588.001 114.728 603.505 124.983C607.42 127.703 610.643 131.303 612.915 135.494C614.324 138.117 615.359 140.923 615.99 143.832"
      fill="#232B41"
      class="tblr-illustrations-computer-fix-d"
    />
    <path
      d="M600.744 153.028C593.293 160.265 571.583 178.771 552.118 169.904C549.084 168.538 546.266 166.736 543.752 164.556C543.51 164.387 543.293 164.185 543.108 163.955C542.496 163.409 541.918 162.827 541.378 162.21L541.22 162.053C539.83 160.447 538.709 158.626 537.902 156.661C542.634 159.548 547.809 161.635 553.219 162.839C580.007 168.674 602.146 148.724 605.678 145.534L605.95 145.291C604.428 148.012 602.707 150.618 600.801 153.086"
      fill="black"
      opacity="0.5"
    />
    <path
      d="M483.942 177.727C483.944 179.167 483.81 180.604 483.542 182.018H457.484C457.216 180.604 457.082 179.167 457.083 177.727C457.072 175.8 457.298 173.879 457.756 172.007H483.284C483.729 173.881 483.95 175.801 483.942 177.727Z"
      fill="black"
      opacity="0.3"
    />
    <path
      d="M466.422 169.089C467.695 170.426 468.769 171.938 469.612 173.58C472.744 179.386 472.315 185.679 468.053 189.169C462.618 193.559 453.165 191.729 446.872 185.064C446.186 184.326 445.55 183.543 444.97 182.719C440.493 176.412 440.451 168.875 445.256 164.999C450.633 160.594 460.144 162.425 466.422 169.089Z"
      fill="#FFCB9D"
      style="fill: #ffcb9d; fill: var(--tblr-illustrations-skin, #ffcb9d)"
    />
    <path
      d="M466.422 169.089C467.695 170.426 468.769 171.938 469.612 173.58C469.011 173.98 468.468 174.338 467.881 174.695C460.144 179.344 455.167 178.385 446.114 182.161C445.722 182.324 445.34 182.51 444.97 182.719C440.493 176.412 440.451 168.875 445.256 164.999C450.633 160.594 460.144 162.425 466.422 169.089Z"
      fill="black"
      opacity="0.1"
    />
    <path
      d="M585.599 343.37V364.122L575.587 372.703V346.831L585.384 342.212L585.599 343.37Z"
      fill="black"
      opacity="0.15"
    />
    <path
      d="M520.025 263.695C518.559 268.03 515.781 271.802 512.076 274.488C508.37 277.173 503.921 278.64 499.345 278.683L483.141 326.766L476.205 347.274L473.273 355.927C476.717 358.617 479.284 362.269 480.65 366.42C482.016 370.571 482.119 375.034 480.946 379.243C479.772 383.452 477.376 387.219 474.059 390.064C470.743 392.91 466.657 394.707 462.318 395.228L469.04 375.377C469.299 374.598 469.24 373.747 468.876 373.011C468.512 372.274 467.872 371.711 467.095 371.444L454.967 367.34C454.187 367.08 453.337 367.139 452.6 367.503C451.864 367.867 451.301 368.508 451.034 369.285L444.326 389.135C441.191 386.09 439.031 382.181 438.122 377.905C437.212 373.629 437.594 369.179 439.219 365.121C440.843 361.063 443.637 357.579 447.246 355.112C450.855 352.644 455.115 351.305 459.486 351.265L462.347 342.941L469.412 322.046L485.573 274.021C482.129 271.331 479.561 267.679 478.195 263.528C476.829 259.377 476.726 254.914 477.9 250.705C479.073 246.495 481.47 242.729 484.786 239.883C488.102 237.038 492.189 235.24 496.528 234.72L489.806 254.571C489.673 254.956 489.619 255.365 489.645 255.772C489.671 256.179 489.778 256.577 489.959 256.942C490.14 257.308 490.391 257.634 490.699 257.902C491.006 258.17 491.364 258.375 491.751 258.504L503.864 262.608C504.644 262.868 505.494 262.809 506.231 262.445C506.967 262.08 507.53 261.44 507.797 260.663L514.519 240.812C517.507 243.715 519.611 247.406 520.585 251.457C521.56 255.507 521.366 259.751 520.025 263.695Z"
      fill="#A7AAB3"
    />
    <path
      d="M483.141 326.766L476.205 347.274C473.637 346.92 471.106 346.341 468.639 345.544C466.472 344.831 464.359 343.961 462.318 342.941L469.383 322.046C471.541 322.405 473.668 322.926 475.747 323.605C478.306 324.422 480.782 325.48 483.141 326.766Z"
      fill="black"
      opacity="0.1"
    />
    <path
      d="M477.421 302.581C474.667 302.666 471.941 303.148 469.326 304.012C459.915 306.872 453.765 314.023 454.638 322.175C455.782 332.544 467.738 340.524 481.396 340.052C482.907 339.986 484.412 339.823 485.901 339.566C497.257 337.549 505.209 329.555 504.179 320.459C503.063 310.147 491.05 302.11 477.421 302.581Z"
      fill="#FFCB9D"
      style="fill: #ffcb9d; fill: var(--tblr-illustrations-skin, #ffcb9d)"
    />
    <path
      d="M477.42 302.581C474.667 302.666 471.941 303.148 469.326 304.012C469.555 305.07 469.755 306.014 470.012 307.001C473.344 320.058 479.623 324.263 485.244 337.764C485.499 338.35 485.719 338.952 485.901 339.566C497.257 337.549 505.209 329.555 504.179 320.459C503.063 310.147 491.05 302.11 477.42 302.581Z"
      fill="black"
      opacity="0.1"
    />
    <path
      d="M640.36 287.951C638.93 310.59 624.628 332.93 601.002 350.178C579.177 366.095 549.387 377.694 514.391 381.184C508.167 370.155 502.23 358.967 496.585 347.632C494.726 343.928 492.909 340.181 491.079 336.362C483.928 321.46 477.664 307.044 472.129 293.271C487.689 298.377 551.975 318.442 589.932 302.152C596.811 299.206 610.541 293.4 612.486 282.13C613.048 278.08 612.317 273.956 610.398 270.345C608.798 267.347 607.829 264.053 607.55 260.666C607.271 257.279 607.688 253.871 608.776 250.652C609.864 247.432 611.599 244.469 613.876 241.946C616.152 239.422 618.92 237.392 622.011 235.978C640.46 260.177 640.861 279.87 640.36 287.951Z"
      fill="#0455A4"
      style="fill: #0455a4; fill: var(--tblr-illustrations-primary, var(--tblr-primary, #0455a4))"
    />
    <path
      d="M601.002 350.178C579.177 366.095 549.387 377.694 514.39 381.184C511.347 375.792 508.372 370.361 505.466 364.894C501.376 357.2 497.519 349.634 493.896 342.197C505.942 349.292 519.121 354.256 532.854 356.871C555.749 361.042 579.355 358.723 601.002 350.178Z"
      fill="black"
      opacity="0.1"
    />
  </svg>
</div>
{%- endcapture %}
{% include "docs/example.html" html=html %}

## Color of the skin

To change the color of the skin, use the `--tblr-illustrations-skin` CSS variable.

```html
<div style="--tblr-illustrations-skin: #5a433c">
  <svg>...</svg>
</div>
```

Look at the example below to see how you can change the color of the skin.

{% capture html -%}
<div style="--tblr-illustrations-skin: #5a433c">
  <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 800 600">
    <path
      d="M165.042 305.17C165.042 347.031 209.306 377.394 228.857 411.189C249.036 446.056 253.885 499.359 288.752 519.524C322.562 539.075 370.673 517.207 412.534 517.207C454.395 517.207 502.506 539.075 536.301 519.524C571.168 499.359 576.017 446.056 596.196 411.189C615.747 377.394 660.011 347.031 660.011 305.17C660.011 263.309 615.747 232.961 596.196 199.166C576.017 164.298 571.168 110.996 536.301 90.8302C502.506 71.2798 454.381 93.1471 412.534 93.1471C370.687 93.1471 322.562 71.2798 288.752 90.8302C253.885 110.996 249.036 164.298 228.857 199.166C209.306 232.961 165.042 263.323 165.042 305.17Z"
      fill="#F7F8FC"
      class="tblr-illustrations-computer-fix-a"
    />
    <path
      d="M375.492 479.923C470.481 479.923 547.485 476.824 547.485 473.001C547.485 469.178 470.481 466.079 375.492 466.079C280.503 466.079 203.5 469.178 203.5 473.001C203.5 476.824 280.503 479.923 375.492 479.923Z"
      fill="#A6A9B3"
      class="tblr-illustrations-computer-fix-b"
    />
    <path
      d="M511.988 174.667C493.855 167.122 474.216 163.9 454.624 165.256L456.64 177.084L511.988 174.667Z"
      fill="#0455A4"
      style="fill: #0455a4; fill: var(--tblr-illustrations-primary, var(--tblr-primary, #0455a4))"
    />
    <path
      d="M518.452 301.638L572.584 329.197L591.949 299.006L602.918 281.844C608.639 272.891 617.062 260.034 627.674 244.159C626.096 241.199 624.176 238.434 621.954 235.921C616.989 230.419 610.739 226.233 603.762 223.736H603.633C599.858 222.306 595.996 221.019 592.192 219.674C585.755 217.369 579.457 214.695 573.328 211.665C568.623 209.377 563.545 206.66 558.154 203.428C555.15 210.807 552.161 218.187 549.187 225.567C543.466 239.868 537.697 254.132 531.881 268.357C527.419 279.465 522.943 290.558 518.452 301.638Z"
      fill="#DADBE0"
    />
    <path
      d="M573.328 211.665L580.908 225.338L581.866 225.567C589.204 227.065 596.817 226.429 603.805 223.736H603.676C599.9 222.306 596.039 221.019 592.235 219.674C585.784 217.371 579.471 214.697 573.328 211.665Z"
      fill="#FFCB9D"
      style="fill: #ffcb9d; fill: var(--tblr-illustrations-skin, #ffcb9d)"
    />
    <path
      d="M627.674 244.216C617.062 260.091 608.696 272.948 602.918 281.901C601.087 284.762 599.757 286.807 594.509 295.016L591.949 299.006L582.738 313.308L572.584 329.14L518.466 301.623C522.928 290.563 527.405 279.494 531.896 268.415L549.186 225.638C549.286 225.409 549.372 225.181 549.472 224.966C551.379 220.132 553.329 215.303 555.322 210.478C556.275 208.152 557.229 205.816 558.182 203.471C561.171 205.287 564.089 206.917 566.878 208.405C569.109 209.606 571.268 210.707 573.356 211.737C579.485 214.732 585.778 217.377 592.206 219.66C596.01 221.004 599.872 222.234 603.647 223.722H603.776C604.648 224.079 605.521 224.423 606.365 224.823C612.359 227.307 617.709 231.121 622.011 235.978C624.209 238.497 626.11 241.261 627.674 244.216Z"
      fill="#0455A4"
      style="fill: #0455a4; fill: var(--tblr-illustrations-primary, var(--tblr-primary, #0455a4))"
    />
    <path
      d="M600.816 220.246C592.321 224.537 585.441 224.852 580.507 224.165C580.221 224.165 579.95 224.094 579.678 224.036L572.069 212.595C578.204 212.59 584.3 213.555 590.132 215.455C593.844 216.693 597.423 218.298 600.816 220.246Z"
      fill="#FFCB9D"
      style="fill: #ffcb9d; fill: var(--tblr-illustrations-skin, #ffcb9d)"
    />
    <path
      d="M191.729 429.895L559.226 429.895C571.011 429.895 580.564 420.342 580.564 408.557V198.408C580.564 186.623 571.011 177.07 559.226 177.07L191.729 177.07C179.945 177.07 170.391 186.623 170.391 198.408V408.557C170.391 420.342 179.945 429.895 191.729 429.895Z"
      fill="white"
      class="tblr-illustrations-computer-fix-c"
    />
    <path
      d="M585.585 197.736C585.395 190.871 582.538 184.35 577.619 179.557C572.701 174.764 566.108 172.076 559.241 172.064H191.687C184.702 172.072 178.006 174.849 173.067 179.788C168.128 184.727 165.35 191.423 165.343 198.408V408.643C165.35 415.628 168.128 422.324 173.067 427.263C178.006 432.201 184.702 434.979 191.687 434.987H326.008V443.94C324.578 453.679 318.042 456.425 313.466 457.126H262.537C261.503 457.13 260.512 457.542 259.781 458.274C259.049 459.005 258.637 459.996 258.633 461.03V465.55C258.637 466.584 259.049 467.575 259.781 468.306C260.512 469.038 261.503 469.45 262.537 469.454H488.504C489.017 469.454 489.525 469.353 489.999 469.157C490.472 468.961 490.903 468.673 491.265 468.31C491.628 467.948 491.915 467.517 492.112 467.044C492.308 466.57 492.409 466.062 492.409 465.55V461.03C492.409 460.517 492.308 460.01 492.112 459.536C491.915 459.062 491.628 458.632 491.265 458.269C490.903 457.907 490.472 457.619 489.999 457.423C489.525 457.227 489.017 457.126 488.504 457.126H437.476C432.899 456.425 426.306 453.665 424.933 443.868V434.915H559.241C566.226 434.908 572.924 432.13 577.865 427.192C582.806 422.254 585.587 415.557 585.599 408.571V198.336C585.599 198.179 585.599 197.964 585.585 197.736ZM575.573 408.571C575.57 412.898 573.849 417.047 570.79 420.106C567.73 423.166 563.582 424.886 559.255 424.89H191.701C187.374 424.886 183.226 423.166 180.166 420.106C177.107 417.047 175.386 412.898 175.383 408.571V198.336C175.386 194.01 177.107 189.861 180.166 186.802C183.226 183.742 187.374 182.022 191.701 182.018H559.255C561.484 182.012 563.691 182.469 565.734 183.362C568.656 184.626 571.144 186.717 572.892 189.378C574.641 192.039 575.573 195.153 575.573 198.336V408.571Z"
      fill="#232B41"
      class="tblr-illustrations-computer-fix-d"
    />
    <path
      d="M211.108 222.706L443.454 222.706C444.497 222.706 445.342 221.861 445.342 220.819V214.798C445.342 213.755 444.497 212.91 443.454 212.91L211.108 212.91C210.066 212.91 209.22 213.755 209.22 214.798V220.819C209.22 221.861 210.066 222.706 211.108 222.706Z"
      fill="#0455A4"
      style="fill: #0455a4; fill: var(--tblr-illustrations-primary, var(--tblr-primary, #0455a4))"
    />
    <path
      d="M211.094 314.981H252.111C253.146 314.981 253.985 314.142 253.985 313.108V307.058C253.985 306.023 253.146 305.184 252.111 305.184H211.094C210.059 305.184 209.22 306.023 209.22 307.058V313.108C209.22 314.142 210.059 314.981 211.094 314.981Z"
      fill="#DADBE0"
    />
    <path
      d="M211.809 279.856H368.97C370.4 279.856 371.559 278.697 371.559 277.267V250.595C371.559 249.165 370.4 248.006 368.97 248.006L211.809 248.006C210.379 248.006 209.22 249.165 209.22 250.595V277.267C209.22 278.697 210.379 279.856 211.809 279.856Z"
      fill="#A7AAB3"
    />
    <path
      d="M389.479 335.733L382.271 326.78L363.822 341.611L346.56 320.144L331.586 332.2L348.848 353.667L330.399 368.498L337.593 377.465L356.042 362.62L373.304 384.087L388.292 372.031L371.03 350.564L389.479 335.733Z"
      fill="#0455A4"
      style="fill: #0455a4; fill: var(--tblr-illustrations-primary, var(--tblr-primary, #0455a4))"
    />
    <path
      d="M591.934 268.701C593.522 258.689 602.961 233.776 606.393 224.895C605.55 224.494 604.677 224.151 603.805 223.793H603.676C597.784 223.936 594.695 223.45 594.451 222.363C594.266 221.548 595.567 220.418 598.356 218.945C595.969 217.727 593.498 216.68 590.962 215.813C589.216 215.204 587.44 214.684 585.642 214.254L585.413 309.389C587.615 305.957 589.818 302.539 592.006 299.106L594.566 295.116C592.635 286.034 590.919 275.094 591.934 268.701ZM485.401 254.857C484.8 254.942 484.114 259.376 486.288 262.208C486.835 262.909 487.534 263.476 488.333 263.867C487.189 258.861 486.002 254.785 485.401 254.857ZM507.354 307.487C505.774 306.55 504.119 305.747 502.406 305.084C503.966 306.056 505.625 306.862 507.354 307.487ZM469.283 332.115L465.765 355.569L469.583 349.491C469.14 343.71 469.039 337.908 469.283 332.115ZM514.004 331.385C514.763 329.722 515.32 327.975 515.663 326.179C506.08 322.786 496.693 318.861 487.546 314.423C485.44 321.176 482.706 327.717 479.38 333.959L469.583 349.534C469.755 351.293 469.984 353.038 470.298 354.711C472.043 364.122 476.219 370.586 479.408 375.535C485.661 385.147 494.013 393.215 503.836 399.132C530.306 400.116 556.093 390.607 575.588 372.674V364.994L514.004 331.385Z"
      fill="black"
      opacity="0.1"
    />
    <path
      d="M514.376 314.638C512.764 311.667 510.325 309.227 507.354 307.616C505.625 306.99 503.966 306.185 502.406 305.213L502.148 305.084C502.148 305.084 502.248 305.084 502.406 305.213C504.119 305.875 505.774 306.679 507.354 307.616C507.997 307.787 508.527 307.802 508.784 307.53C510.1 306.243 503.478 300.451 502.005 290.783C501.633 288.251 500.761 282.502 504.05 277.182C508.169 270.517 515.935 269.244 517.422 269.015C511.358 267.019 505.07 265.785 498.701 265.34C494.411 265.039 490.835 265.182 488.318 263.91C489.348 268.372 490.349 273.549 490.864 277.153C492.515 289.684 491.377 302.426 487.532 314.466C496.679 318.904 506.065 322.829 515.649 326.222C516.477 322.324 516.031 318.263 514.376 314.638ZM585.584 175.096V229.042C582.59 228.905 579.63 228.351 576.789 227.397C565.562 223.564 557.567 213.668 557.567 202.069C557.567 190.47 565.562 180.616 576.789 176.741C579.63 175.787 582.59 175.233 585.584 175.096Z"
      fill="black"
      opacity="0.1"
    />
    <path
      d="M585.57 222.935L609.483 216.128L613.501 223.278L588.974 239.868C587.816 237.194 586.643 234.505 585.484 231.817C585.556 228.827 585.556 225.967 585.57 222.935Z"
      fill="#DADBE0"
    />
    <path
      d="M585.584 175.096V229.042C582.59 228.905 579.63 228.351 576.789 227.397L575.559 226.954V198.351C575.558 195.167 574.626 192.053 572.878 189.392C571.13 186.732 568.641 184.641 565.719 183.377C568.431 180.786 571.61 178.733 575.087 177.327C575.645 177.098 576.217 176.884 576.789 176.683C579.633 175.749 582.593 175.215 585.584 175.096Z"
      fill="black"
      opacity="0.3"
    />
    <path
      d="M610.198 137.454C611.056 141.973 612.186 148.609 613.358 156.818C613.587 158.62 613.816 160.194 613.902 160.737C614.881 169.779 614.722 178.908 613.43 187.91C613.144 189.698 612.843 191.4 612.429 193.073C611.299 197.707 600.287 205.258 587.072 209.706C582.519 211.261 577.817 212.34 573.042 212.924C558.182 214.712 548.414 204.586 548.343 195.762C548.293 193.608 548.896 191.488 550.073 189.684C552.13 186.006 553.496 181.983 554.106 177.813C555.126 172.287 555.748 166.695 555.966 161.08C556.166 157.877 556.151 155.789 556.151 155.789L567.593 140.214L601.845 132.348C602.761 138.197 605.178 141.844 607.066 141.787C608.953 141.73 609.955 138.212 610.198 137.454Z"
      fill="#FFCB9D"
      style="fill: #ffcb9d; fill: var(--tblr-illustrations-skin, #ffcb9d)"
    />
    <path
      d="M610.198 137.454C611.041 141.973 612.185 148.609 613.373 156.818C613.587 158.62 613.816 160.208 613.887 160.737C614.877 169.778 614.728 178.907 613.444 187.91C611.07 187.716 608.754 187.071 606.622 186.008C604.293 184.813 602.223 183.171 600.53 181.174C598.789 179.022 597.399 176.608 596.411 174.023C595.671 172.382 595.036 170.696 594.509 168.975C582.401 176.336 568.178 179.433 554.106 177.77C555.126 172.244 555.747 166.652 555.965 161.037C556.166 157.834 556.151 155.731 556.151 155.731L567.593 140.171L601.845 132.348C602.761 138.197 605.178 141.844 607.065 141.773C608.953 141.701 610.026 138.212 610.269 137.482"
      fill="black"
      opacity="0.1"
    />
    <path
      d="M616.147 143.804C617.621 150.946 616.333 158.382 612.543 164.613C611.699 165.705 610.934 166.857 610.255 168.059C608.586 171.497 607.8 175.297 607.967 179.115C605.963 177.555 604.47 175.434 603.676 173.022C602.575 169.318 602.618 161.996 602.475 161.009V160.408C602.475 160.079 602.389 159.636 602.275 158.778C601.977 156.941 601.562 155.126 601.03 153.343C601.023 153.249 600.988 153.16 600.93 153.086C593.479 160.322 571.769 178.829 552.304 169.962C549.27 168.595 546.452 166.793 543.938 164.613C543.696 164.444 543.479 164.242 543.294 164.012C542.682 163.466 542.104 162.884 541.564 162.267L541.406 162.11C540.013 160.506 538.892 158.685 538.088 156.718L537.488 155.889C537.211 155.006 537.005 154.102 536.873 153.186C536.555 149.566 537.5 145.948 539.547 142.946C543.251 137.068 549.701 132.62 553.105 130.303C566.291 121.136 588.001 114.728 603.505 124.983C607.42 127.703 610.643 131.303 612.915 135.494C614.324 138.117 615.359 140.923 615.99 143.832"
      fill="#232B41"
      class="tblr-illustrations-computer-fix-d"
    />
    <path
      d="M600.744 153.028C593.293 160.265 571.583 178.771 552.118 169.904C549.084 168.538 546.266 166.736 543.752 164.556C543.51 164.387 543.293 164.185 543.108 163.955C542.496 163.409 541.918 162.827 541.378 162.21L541.22 162.053C539.83 160.447 538.709 158.626 537.902 156.661C542.634 159.548 547.809 161.635 553.219 162.839C580.007 168.674 602.146 148.724 605.678 145.534L605.95 145.291C604.428 148.012 602.707 150.618 600.801 153.086"
      fill="black"
      opacity="0.5"
    />
    <path
      d="M483.942 177.727C483.944 179.167 483.81 180.604 483.542 182.018H457.484C457.216 180.604 457.082 179.167 457.083 177.727C457.072 175.8 457.298 173.879 457.756 172.007H483.284C483.729 173.881 483.95 175.801 483.942 177.727Z"
      fill="black"
      opacity="0.3"
    />
    <path
      d="M466.422 169.089C467.695 170.426 468.769 171.938 469.612 173.58C472.744 179.386 472.315 185.679 468.053 189.169C462.618 193.559 453.165 191.729 446.872 185.064C446.186 184.326 445.55 183.543 444.97 182.719C440.493 176.412 440.451 168.875 445.256 164.999C450.633 160.594 460.144 162.425 466.422 169.089Z"
      fill="#FFCB9D"
      style="fill: #ffcb9d; fill: var(--tblr-illustrations-skin, #ffcb9d)"
    />
    <path
      d="M466.422 169.089C467.695 170.426 468.769 171.938 469.612 173.58C469.011 173.98 468.468 174.338 467.881 174.695C460.144 179.344 455.167 178.385 446.114 182.161C445.722 182.324 445.34 182.51 444.97 182.719C440.493 176.412 440.451 168.875 445.256 164.999C450.633 160.594 460.144 162.425 466.422 169.089Z"
      fill="black"
      opacity="0.1"
    />
    <path
      d="M585.599 343.37V364.122L575.587 372.703V346.831L585.384 342.212L585.599 343.37Z"
      fill="black"
      opacity="0.15"
    />
    <path
      d="M520.025 263.695C518.559 268.03 515.781 271.802 512.076 274.488C508.37 277.173 503.921 278.64 499.345 278.683L483.141 326.766L476.205 347.274L473.273 355.927C476.717 358.617 479.284 362.269 480.65 366.42C482.016 370.571 482.119 375.034 480.946 379.243C479.772 383.452 477.376 387.219 474.059 390.064C470.743 392.91 466.657 394.707 462.318 395.228L469.04 375.377C469.299 374.598 469.24 373.747 468.876 373.011C468.512 372.274 467.872 371.711 467.095 371.444L454.967 367.34C454.187 367.08 453.337 367.139 452.6 367.503C451.864 367.867 451.301 368.508 451.034 369.285L444.326 389.135C441.191 386.09 439.031 382.181 438.122 377.905C437.212 373.629 437.594 369.179 439.219 365.121C440.843 361.063 443.637 357.579 447.246 355.112C450.855 352.644 455.115 351.305 459.486 351.265L462.347 342.941L469.412 322.046L485.573 274.021C482.129 271.331 479.561 267.679 478.195 263.528C476.829 259.377 476.726 254.914 477.9 250.705C479.073 246.495 481.47 242.729 484.786 239.883C488.102 237.038 492.189 235.24 496.528 234.72L489.806 254.571C489.673 254.956 489.619 255.365 489.645 255.772C489.671 256.179 489.778 256.577 489.959 256.942C490.14 257.308 490.391 257.634 490.699 257.902C491.006 258.17 491.364 258.375 491.751 258.504L503.864 262.608C504.644 262.868 505.494 262.809 506.231 262.445C506.967 262.08 507.53 261.44 507.797 260.663L514.519 240.812C517.507 243.715 519.611 247.406 520.585 251.457C521.56 255.507 521.366 259.751 520.025 263.695Z"
      fill="#A7AAB3"
    />
    <path
      d="M483.141 326.766L476.205 347.274C473.637 346.92 471.106 346.341 468.639 345.544C466.472 344.831 464.359 343.961 462.318 342.941L469.383 322.046C471.541 322.405 473.668 322.926 475.747 323.605C478.306 324.422 480.782 325.48 483.141 326.766Z"
      fill="black"
      opacity="0.1"
    />
    <path
      d="M477.421 302.581C474.667 302.666 471.941 303.148 469.326 304.012C459.915 306.872 453.765 314.023 454.638 322.175C455.782 332.544 467.738 340.524 481.396 340.052C482.907 339.986 484.412 339.823 485.901 339.566C497.257 337.549 505.209 329.555 504.179 320.459C503.063 310.147 491.05 302.11 477.421 302.581Z"
      fill="#FFCB9D"
      style="fill: #ffcb9d; fill: var(--tblr-illustrations-skin, #ffcb9d)"
    />
    <path
      d="M477.42 302.581C474.667 302.666 471.941 303.148 469.326 304.012C469.555 305.07 469.755 306.014 470.012 307.001C473.344 320.058 479.623 324.263 485.244 337.764C485.499 338.35 485.719 338.952 485.901 339.566C497.257 337.549 505.209 329.555 504.179 320.459C503.063 310.147 491.05 302.11 477.42 302.581Z"
      fill="black"
      opacity="0.1"
    />
    <path
      d="M640.36 287.951C638.93 310.59 624.628 332.93 601.002 350.178C579.177 366.095 549.387 377.694 514.391 381.184C508.167 370.155 502.23 358.967 496.585 347.632C494.726 343.928 492.909 340.181 491.079 336.362C483.928 321.46 477.664 307.044 472.129 293.271C487.689 298.377 551.975 318.442 589.932 302.152C596.811 299.206 610.541 293.4 612.486 282.13C613.048 278.08 612.317 273.956 610.398 270.345C608.798 267.347 607.829 264.053 607.55 260.666C607.271 257.279 607.688 253.871 608.776 250.652C609.864 247.432 611.599 244.469 613.876 241.946C616.152 239.422 618.92 237.392 622.011 235.978C640.46 260.177 640.861 279.87 640.36 287.951Z"
      fill="#0455A4"
      style="fill: #0455a4; fill: var(--tblr-illustrations-primary, var(--tblr-primary, #0455a4))"
    />
    <path
      d="M601.002 350.178C579.177 366.095 549.387 377.694 514.39 381.184C511.347 375.792 508.372 370.361 505.466 364.894C501.376 357.2 497.519 349.634 493.896 342.197C505.942 349.292 519.121 354.256 532.854 356.871C555.749 361.042 579.355 358.723 601.002 350.178Z"
      fill="black"
      opacity="0.1"
    />
  </svg>
</div>
{%- endcapture %}
{% include "docs/example.html" html=html %}


## Application Brand Color

Tabler Illustrations uses `--tblr-primary` as a fallback color if `--tblr-illustrations-primary` is not set, so if you have a primary color set in your design system, you can use that to ensure consistency across your project.

{% capture html -%}
<div class="card">
  <div class="card-body">
    <div>
      <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 800 600">
        <path
          d="M165.042 305.17C165.042 347.031 209.306 377.394 228.857 411.189C249.036 446.056 253.885 499.359 288.752 519.524C322.562 539.075 370.673 517.207 412.534 517.207C454.395 517.207 502.506 539.075 536.301 519.524C571.168 499.359 576.017 446.056 596.196 411.189C615.747 377.394 660.011 347.031 660.011 305.17C660.011 263.309 615.747 232.961 596.196 199.166C576.017 164.298 571.168 110.996 536.301 90.8302C502.506 71.2798 454.381 93.1471 412.534 93.1471C370.687 93.1471 322.562 71.2798 288.752 90.8302C253.885 110.996 249.036 164.298 228.857 199.166C209.306 232.961 165.042 263.323 165.042 305.17Z"
          fill="#F7F8FC"
          class="tblr-illustrations-computer-fix-a"
        />
        <path
          d="M375.492 479.923C470.481 479.923 547.485 476.824 547.485 473.001C547.485 469.178 470.481 466.079 375.492 466.079C280.503 466.079 203.5 469.178 203.5 473.001C203.5 476.824 280.503 479.923 375.492 479.923Z"
          fill="#A6A9B3"
          class="tblr-illustrations-computer-fix-b"
        />
        <path
          d="M511.988 174.667C493.855 167.122 474.216 163.9 454.624 165.256L456.64 177.084L511.988 174.667Z"
          fill="#0455A4"
          style="
            fill: #0455a4;
            fill: var(--tblr-illustrations-primary, var(--tblr-primary, #0455a4));
          "
        />
        <path
          d="M518.452 301.638L572.584 329.197L591.949 299.006L602.918 281.844C608.639 272.891 617.062 260.034 627.674 244.159C626.096 241.199 624.176 238.434 621.954 235.921C616.989 230.419 610.739 226.233 603.762 223.736H603.633C599.858 222.306 595.996 221.019 592.192 219.674C585.755 217.369 579.457 214.695 573.328 211.665C568.623 209.377 563.545 206.66 558.154 203.428C555.15 210.807 552.161 218.187 549.187 225.567C543.466 239.868 537.697 254.132 531.881 268.357C527.419 279.465 522.943 290.558 518.452 301.638Z"
          fill="#DADBE0"
        />
        <path
          d="M573.328 211.665L580.908 225.338L581.866 225.567C589.204 227.065 596.817 226.429 603.805 223.736H603.676C599.9 222.306 596.039 221.019 592.235 219.674C585.784 217.371 579.471 214.697 573.328 211.665Z"
          fill="#FFCB9D"
          style="fill: #ffcb9d; fill: var(--tblr-illustrations-skin, #ffcb9d)"
        />
        <path
          d="M627.674 244.216C617.062 260.091 608.696 272.948 602.918 281.901C601.087 284.762 599.757 286.807 594.509 295.016L591.949 299.006L582.738 313.308L572.584 329.14L518.466 301.623C522.928 290.563 527.405 279.494 531.896 268.415L549.186 225.638C549.286 225.409 549.372 225.181 549.472 224.966C551.379 220.132 553.329 215.303 555.322 210.478C556.275 208.152 557.229 205.816 558.182 203.471C561.171 205.287 564.089 206.917 566.878 208.405C569.109 209.606 571.268 210.707 573.356 211.737C579.485 214.732 585.778 217.377 592.206 219.66C596.01 221.004 599.872 222.234 603.647 223.722H603.776C604.648 224.079 605.521 224.423 606.365 224.823C612.359 227.307 617.709 231.121 622.011 235.978C624.209 238.497 626.11 241.261 627.674 244.216Z"
          fill="#0455A4"
          style="
            fill: #0455a4;
            fill: var(--tblr-illustrations-primary, var(--tblr-primary, #0455a4));
          "
        />
        <path
          d="M600.816 220.246C592.321 224.537 585.441 224.852 580.507 224.165C580.221 224.165 579.95 224.094 579.678 224.036L572.069 212.595C578.204 212.59 584.3 213.555 590.132 215.455C593.844 216.693 597.423 218.298 600.816 220.246Z"
          fill="#FFCB9D"
          style="fill: #ffcb9d; fill: var(--tblr-illustrations-skin, #ffcb9d)"
        />
        <path
          d="M191.729 429.895L559.226 429.895C571.011 429.895 580.564 420.342 580.564 408.557V198.408C580.564 186.623 571.011 177.07 559.226 177.07L191.729 177.07C179.945 177.07 170.391 186.623 170.391 198.408V408.557C170.391 420.342 179.945 429.895 191.729 429.895Z"
          fill="white"
          class="tblr-illustrations-computer-fix-c"
        />
        <path
          d="M585.585 197.736C585.395 190.871 582.538 184.35 577.619 179.557C572.701 174.764 566.108 172.076 559.241 172.064H191.687C184.702 172.072 178.006 174.849 173.067 179.788C168.128 184.727 165.35 191.423 165.343 198.408V408.643C165.35 415.628 168.128 422.324 173.067 427.263C178.006 432.201 184.702 434.979 191.687 434.987H326.008V443.94C324.578 453.679 318.042 456.425 313.466 457.126H262.537C261.503 457.13 260.512 457.542 259.781 458.274C259.049 459.005 258.637 459.996 258.633 461.03V465.55C258.637 466.584 259.049 467.575 259.781 468.306C260.512 469.038 261.503 469.45 262.537 469.454H488.504C489.017 469.454 489.525 469.353 489.999 469.157C490.472 468.961 490.903 468.673 491.265 468.31C491.628 467.948 491.915 467.517 492.112 467.044C492.308 466.57 492.409 466.062 492.409 465.55V461.03C492.409 460.517 492.308 460.01 492.112 459.536C491.915 459.062 491.628 458.632 491.265 458.269C490.903 457.907 490.472 457.619 489.999 457.423C489.525 457.227 489.017 457.126 488.504 457.126H437.476C432.899 456.425 426.306 453.665 424.933 443.868V434.915H559.241C566.226 434.908 572.924 432.13 577.865 427.192C582.806 422.254 585.587 415.557 585.599 408.571V198.336C585.599 198.179 585.599 197.964 585.585 197.736ZM575.573 408.571C575.57 412.898 573.849 417.047 570.79 420.106C567.73 423.166 563.582 424.886 559.255 424.89H191.701C187.374 424.886 183.226 423.166 180.166 420.106C177.107 417.047 175.386 412.898 175.383 408.571V198.336C175.386 194.01 177.107 189.861 180.166 186.802C183.226 183.742 187.374 182.022 191.701 182.018H559.255C561.484 182.012 563.691 182.469 565.734 183.362C568.656 184.626 571.144 186.717 572.892 189.378C574.641 192.039 575.573 195.153 575.573 198.336V408.571Z"
          fill="#232B41"
          class="tblr-illustrations-computer-fix-d"
        />
        <path
          d="M211.108 222.706L443.454 222.706C444.497 222.706 445.342 221.861 445.342 220.819V214.798C445.342 213.755 444.497 212.91 443.454 212.91L211.108 212.91C210.066 212.91 209.22 213.755 209.22 214.798V220.819C209.22 221.861 210.066 222.706 211.108 222.706Z"
          fill="#0455A4"
          style="
            fill: #0455a4;
            fill: var(--tblr-illustrations-primary, var(--tblr-primary, #0455a4));
          "
        />
        <path
          d="M211.094 314.981H252.111C253.146 314.981 253.985 314.142 253.985 313.108V307.058C253.985 306.023 253.146 305.184 252.111 305.184H211.094C210.059 305.184 209.22 306.023 209.22 307.058V313.108C209.22 314.142 210.059 314.981 211.094 314.981Z"
          fill="#DADBE0"
        />
        <path
          d="M211.809 279.856H368.97C370.4 279.856 371.559 278.697 371.559 277.267V250.595C371.559 249.165 370.4 248.006 368.97 248.006L211.809 248.006C210.379 248.006 209.22 249.165 209.22 250.595V277.267C209.22 278.697 210.379 279.856 211.809 279.856Z"
          fill="#A7AAB3"
        />
        <path
          d="M389.479 335.733L382.271 326.78L363.822 341.611L346.56 320.144L331.586 332.2L348.848 353.667L330.399 368.498L337.593 377.465L356.042 362.62L373.304 384.087L388.292 372.031L371.03 350.564L389.479 335.733Z"
          fill="#0455A4"
          style="
            fill: #0455a4;
            fill: var(--tblr-illustrations-primary, var(--tblr-primary, #0455a4));
          "
        />
        <path
          d="M591.934 268.701C593.522 258.689 602.961 233.776 606.393 224.895C605.55 224.494 604.677 224.151 603.805 223.793H603.676C597.784 223.936 594.695 223.45 594.451 222.363C594.266 221.548 595.567 220.418 598.356 218.945C595.969 217.727 593.498 216.68 590.962 215.813C589.216 215.204 587.44 214.684 585.642 214.254L585.413 309.389C587.615 305.957 589.818 302.539 592.006 299.106L594.566 295.116C592.635 286.034 590.919 275.094 591.934 268.701ZM485.401 254.857C484.8 254.942 484.114 259.376 486.288 262.208C486.835 262.909 487.534 263.476 488.333 263.867C487.189 258.861 486.002 254.785 485.401 254.857ZM507.354 307.487C505.774 306.55 504.119 305.747 502.406 305.084C503.966 306.056 505.625 306.862 507.354 307.487ZM469.283 332.115L465.765 355.569L469.583 349.491C469.14 343.71 469.039 337.908 469.283 332.115ZM514.004 331.385C514.763 329.722 515.32 327.975 515.663 326.179C506.08 322.786 496.693 318.861 487.546 314.423C485.44 321.176 482.706 327.717 479.38 333.959L469.583 349.534C469.755 351.293 469.984 353.038 470.298 354.711C472.043 364.122 476.219 370.586 479.408 375.535C485.661 385.147 494.013 393.215 503.836 399.132C530.306 400.116 556.093 390.607 575.588 372.674V364.994L514.004 331.385Z"
          fill="black"
          opacity="0.1"
        />
        <path
          d="M514.376 314.638C512.764 311.667 510.325 309.227 507.354 307.616C505.625 306.99 503.966 306.185 502.406 305.213L502.148 305.084C502.148 305.084 502.248 305.084 502.406 305.213C504.119 305.875 505.774 306.679 507.354 307.616C507.997 307.787 508.527 307.802 508.784 307.53C510.1 306.243 503.478 300.451 502.005 290.783C501.633 288.251 500.761 282.502 504.05 277.182C508.169 270.517 515.935 269.244 517.422 269.015C511.358 267.019 505.07 265.785 498.701 265.34C494.411 265.039 490.835 265.182 488.318 263.91C489.348 268.372 490.349 273.549 490.864 277.153C492.515 289.684 491.377 302.426 487.532 314.466C496.679 318.904 506.065 322.829 515.649 326.222C516.477 322.324 516.031 318.263 514.376 314.638ZM585.584 175.096V229.042C582.59 228.905 579.63 228.351 576.789 227.397C565.562 223.564 557.567 213.668 557.567 202.069C557.567 190.47 565.562 180.616 576.789 176.741C579.63 175.787 582.59 175.233 585.584 175.096Z"
          fill="black"
          opacity="0.1"
        />
        <path
          d="M585.57 222.935L609.483 216.128L613.501 223.278L588.974 239.868C587.816 237.194 586.643 234.505 585.484 231.817C585.556 228.827 585.556 225.967 585.57 222.935Z"
          fill="#DADBE0"
        />
        <path
          d="M585.584 175.096V229.042C582.59 228.905 579.63 228.351 576.789 227.397L575.559 226.954V198.351C575.558 195.167 574.626 192.053 572.878 189.392C571.13 186.732 568.641 184.641 565.719 183.377C568.431 180.786 571.61 178.733 575.087 177.327C575.645 177.098 576.217 176.884 576.789 176.683C579.633 175.749 582.593 175.215 585.584 175.096Z"
          fill="black"
          opacity="0.3"
        />
        <path
          d="M610.198 137.454C611.056 141.973 612.186 148.609 613.358 156.818C613.587 158.62 613.816 160.194 613.902 160.737C614.881 169.779 614.722 178.908 613.43 187.91C613.144 189.698 612.843 191.4 612.429 193.073C611.299 197.707 600.287 205.258 587.072 209.706C582.519 211.261 577.817 212.34 573.042 212.924C558.182 214.712 548.414 204.586 548.343 195.762C548.293 193.608 548.896 191.488 550.073 189.684C552.13 186.006 553.496 181.983 554.106 177.813C555.126 172.287 555.748 166.695 555.966 161.08C556.166 157.877 556.151 155.789 556.151 155.789L567.593 140.214L601.845 132.348C602.761 138.197 605.178 141.844 607.066 141.787C608.953 141.73 609.955 138.212 610.198 137.454Z"
          fill="#FFCB9D"
          style="fill: #ffcb9d; fill: var(--tblr-illustrations-skin, #ffcb9d)"
        />
        <path
          d="M610.198 137.454C611.041 141.973 612.185 148.609 613.373 156.818C613.587 158.62 613.816 160.208 613.887 160.737C614.877 169.778 614.728 178.907 613.444 187.91C611.07 187.716 608.754 187.071 606.622 186.008C604.293 184.813 602.223 183.171 600.53 181.174C598.789 179.022 597.399 176.608 596.411 174.023C595.671 172.382 595.036 170.696 594.509 168.975C582.401 176.336 568.178 179.433 554.106 177.77C555.126 172.244 555.747 166.652 555.965 161.037C556.166 157.834 556.151 155.731 556.151 155.731L567.593 140.171L601.845 132.348C602.761 138.197 605.178 141.844 607.065 141.773C608.953 141.701 610.026 138.212 610.269 137.482"
          fill="black"
          opacity="0.1"
        />
        <path
          d="M616.147 143.804C617.621 150.946 616.333 158.382 612.543 164.613C611.699 165.705 610.934 166.857 610.255 168.059C608.586 171.497 607.8 175.297 607.967 179.115C605.963 177.555 604.47 175.434 603.676 173.022C602.575 169.318 602.618 161.996 602.475 161.009V160.408C602.475 160.079 602.389 159.636 602.275 158.778C601.977 156.941 601.562 155.126 601.03 153.343C601.023 153.249 600.988 153.16 600.93 153.086C593.479 160.322 571.769 178.829 552.304 169.962C549.27 168.595 546.452 166.793 543.938 164.613C543.696 164.444 543.479 164.242 543.294 164.012C542.682 163.466 542.104 162.884 541.564 162.267L541.406 162.11C540.013 160.506 538.892 158.685 538.088 156.718L537.488 155.889C537.211 155.006 537.005 154.102 536.873 153.186C536.555 149.566 537.5 145.948 539.547 142.946C543.251 137.068 549.701 132.62 553.105 130.303C566.291 121.136 588.001 114.728 603.505 124.983C607.42 127.703 610.643 131.303 612.915 135.494C614.324 138.117 615.359 140.923 615.99 143.832"
          fill="#232B41"
          class="tblr-illustrations-computer-fix-d"
        />
        <path
          d="M600.744 153.028C593.293 160.265 571.583 178.771 552.118 169.904C549.084 168.538 546.266 166.736 543.752 164.556C543.51 164.387 543.293 164.185 543.108 163.955C542.496 163.409 541.918 162.827 541.378 162.21L541.22 162.053C539.83 160.447 538.709 158.626 537.902 156.661C542.634 159.548 547.809 161.635 553.219 162.839C580.007 168.674 602.146 148.724 605.678 145.534L605.95 145.291C604.428 148.012 602.707 150.618 600.801 153.086"
          fill="black"
          opacity="0.5"
        />
        <path
          d="M483.942 177.727C483.944 179.167 483.81 180.604 483.542 182.018H457.484C457.216 180.604 457.082 179.167 457.083 177.727C457.072 175.8 457.298 173.879 457.756 172.007H483.284C483.729 173.881 483.95 175.801 483.942 177.727Z"
          fill="black"
          opacity="0.3"
        />
        <path
          d="M466.422 169.089C467.695 170.426 468.769 171.938 469.612 173.58C472.744 179.386 472.315 185.679 468.053 189.169C462.618 193.559 453.165 191.729 446.872 185.064C446.186 184.326 445.55 183.543 444.97 182.719C440.493 176.412 440.451 168.875 445.256 164.999C450.633 160.594 460.144 162.425 466.422 169.089Z"
          fill="#FFCB9D"
          style="fill: #ffcb9d; fill: var(--tblr-illustrations-skin, #ffcb9d)"
        />
        <path
          d="M466.422 169.089C467.695 170.426 468.769 171.938 469.612 173.58C469.011 173.98 468.468 174.338 467.881 174.695C460.144 179.344 455.167 178.385 446.114 182.161C445.722 182.324 445.34 182.51 444.97 182.719C440.493 176.412 440.451 168.875 445.256 164.999C450.633 160.594 460.144 162.425 466.422 169.089Z"
          fill="black"
          opacity="0.1"
        />
        <path
          d="M585.599 343.37V364.122L575.587 372.703V346.831L585.384 342.212L585.599 343.37Z"
          fill="black"
          opacity="0.15"
        />
        <path
          d="M520.025 263.695C518.559 268.03 515.781 271.802 512.076 274.488C508.37 277.173 503.921 278.64 499.345 278.683L483.141 326.766L476.205 347.274L473.273 355.927C476.717 358.617 479.284 362.269 480.65 366.42C482.016 370.571 482.119 375.034 480.946 379.243C479.772 383.452 477.376 387.219 474.059 390.064C470.743 392.91 466.657 394.707 462.318 395.228L469.04 375.377C469.299 374.598 469.24 373.747 468.876 373.011C468.512 372.274 467.872 371.711 467.095 371.444L454.967 367.34C454.187 367.08 453.337 367.139 452.6 367.503C451.864 367.867 451.301 368.508 451.034 369.285L444.326 389.135C441.191 386.09 439.031 382.181 438.122 377.905C437.212 373.629 437.594 369.179 439.219 365.121C440.843 361.063 443.637 357.579 447.246 355.112C450.855 352.644 455.115 351.305 459.486 351.265L462.347 342.941L469.412 322.046L485.573 274.021C482.129 271.331 479.561 267.679 478.195 263.528C476.829 259.377 476.726 254.914 477.9 250.705C479.073 246.495 481.47 242.729 484.786 239.883C488.102 237.038 492.189 235.24 496.528 234.72L489.806 254.571C489.673 254.956 489.619 255.365 489.645 255.772C489.671 256.179 489.778 256.577 489.959 256.942C490.14 257.308 490.391 257.634 490.699 257.902C491.006 258.17 491.364 258.375 491.751 258.504L503.864 262.608C504.644 262.868 505.494 262.809 506.231 262.445C506.967 262.08 507.53 261.44 507.797 260.663L514.519 240.812C517.507 243.715 519.611 247.406 520.585 251.457C521.56 255.507 521.366 259.751 520.025 263.695Z"
          fill="#A7AAB3"
        />
        <path
          d="M483.141 326.766L476.205 347.274C473.637 346.92 471.106 346.341 468.639 345.544C466.472 344.831 464.359 343.961 462.318 342.941L469.383 322.046C471.541 322.405 473.668 322.926 475.747 323.605C478.306 324.422 480.782 325.48 483.141 326.766Z"
          fill="black"
          opacity="0.1"
        />
        <path
          d="M477.421 302.581C474.667 302.666 471.941 303.148 469.326 304.012C459.915 306.872 453.765 314.023 454.638 322.175C455.782 332.544 467.738 340.524 481.396 340.052C482.907 339.986 484.412 339.823 485.901 339.566C497.257 337.549 505.209 329.555 504.179 320.459C503.063 310.147 491.05 302.11 477.421 302.581Z"
          fill="#FFCB9D"
          style="fill: #ffcb9d; fill: var(--tblr-illustrations-skin, #ffcb9d)"
        />
        <path
          d="M477.42 302.581C474.667 302.666 471.941 303.148 469.326 304.012C469.555 305.07 469.755 306.014 470.012 307.001C473.344 320.058 479.623 324.263 485.244 337.764C485.499 338.35 485.719 338.952 485.901 339.566C497.257 337.549 505.209 329.555 504.179 320.459C503.063 310.147 491.05 302.11 477.42 302.581Z"
          fill="black"
          opacity="0.1"
        />
        <path
          d="M640.36 287.951C638.93 310.59 624.628 332.93 601.002 350.178C579.177 366.095 549.387 377.694 514.391 381.184C508.167 370.155 502.23 358.967 496.585 347.632C494.726 343.928 492.909 340.181 491.079 336.362C483.928 321.46 477.664 307.044 472.129 293.271C487.689 298.377 551.975 318.442 589.932 302.152C596.811 299.206 610.541 293.4 612.486 282.13C613.048 278.08 612.317 273.956 610.398 270.345C608.798 267.347 607.829 264.053 607.55 260.666C607.271 257.279 607.688 253.871 608.776 250.652C609.864 247.432 611.599 244.469 613.876 241.946C616.152 239.422 618.92 237.392 622.011 235.978C640.46 260.177 640.861 279.87 640.36 287.951Z"
          fill="#0455A4"
          style="
            fill: #0455a4;
            fill: var(--tblr-illustrations-primary, var(--tblr-primary, #0455a4));
          "
        />
        <path
          d="M601.002 350.178C579.177 366.095 549.387 377.694 514.39 381.184C511.347 375.792 508.372 370.361 505.466 364.894C501.376 357.2 497.519 349.634 493.896 342.197C505.942 349.292 519.121 354.256 532.854 356.871C555.749 361.042 579.355 358.723 601.002 350.178Z"
          fill="black"
          opacity="0.1"
        />
      </svg>
    </div>
    <div class="mt-4">
      <button class="btn btn-primary w-100">Primary Button</button>
    </div>
    <div class="mt-4">
      <label class="form-check">
        <input class="form-check-input" type="checkbox" checked />
        <span class="form-check-label">Checked checkbox input</span>
      </label>
    </div>
  </div>
  <div class="ribbon">
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="24"
      height="24"
      viewBox="0 0 24 24"
      fill="none"
      stroke="currentColor"
      stroke-width="2"
      stroke-linecap="round"
      stroke-linejoin="round"
      class="icon icon-tabler icons-tabler-outline icon-tabler-star"
    >
      <path stroke="none" d="M0 0h24v24H0z" fill="none" />
      <path
        d="M12 17.75l-6.172 3.245l1.179 -6.873l-5 -4.867l6.9 -1l3.086 -6.253l3.086 6.253l6.9 1l-5 4.867l1.179 6.873z"
      />
    </svg>
  </div>
</div>
<div class="row g-2">
  <div class="col-auto">
    <label class="form-colorinput">
      <input name="color" type="radio" value="blue" class="form-colorinput-input" checked />
      <span class="form-colorinput-color bg-blue"></span>
    </label>
  </div>
  <div class="col-auto">
    <label class="form-colorinput">
      <input name="color" type="radio" value="azure" class="form-colorinput-input" />
      <span class="form-colorinput-color bg-azure"></span>
    </label>
  </div>
  <div class="col-auto">
    <label class="form-colorinput">
      <input name="color" type="radio" value="indigo" class="form-colorinput-input" />
      <span class="form-colorinput-color bg-indigo"></span>
    </label>
  </div>
  <div class="col-auto">
    <label class="form-colorinput">
      <input name="color" type="radio" value="purple" class="form-colorinput-input" />
      <span class="form-colorinput-color bg-purple"></span>
    </label>
  </div>
  <div class="col-auto">
    <label class="form-colorinput">
      <input name="color" type="radio" value="pink" class="form-colorinput-input" />
      <span class="form-colorinput-color bg-pink"></span>
    </label>
  </div>
  <div class="col-auto">
    <label class="form-colorinput">
      <input name="color" type="radio" value="red" class="form-colorinput-input" />
      <span class="form-colorinput-color bg-red"></span>
    </label>
  </div>
  <div class="col-auto">
    <label class="form-colorinput">
      <input name="color" type="radio" value="orange" class="form-colorinput-input" />
      <span class="form-colorinput-color bg-orange"></span>
    </label>
  </div>
  <div class="col-auto">
    <label class="form-colorinput">
      <input name="color" type="radio" value="yellow" class="form-colorinput-input" />
      <span class="form-colorinput-color bg-yellow"></span>
    </label>
  </div>
  <div class="col-auto">
    <label class="form-colorinput">
      <input name="color" type="radio" value="lime" class="form-colorinput-input" />
      <span class="form-colorinput-color bg-lime"></span>
    </label>
  </div>
  <div class="col-auto">
    <label class="form-colorinput">
      <input name="color" type="radio" value="green" class="form-colorinput-input" />
      <span class="form-colorinput-color bg-green"></span>
    </label>
  </div>
</div>
<script>
  document.querySelectorAll(".form-colorinput-input").forEach((input) => {
    input.addEventListener("change", (event) => {
      document.documentElement.style.setProperty(
        "--tblr-primary",
        `var(--tblr-${event.target.value})`,
      );
    });
  });
</script>
{%- endcapture %}
{% include "docs/example.html" html=html %}

## Dark version of the illustration

Each illustration has a dark mode variant. To use it, copy the dark mode SVG code and paste it into your project. The dark mode variant is available for all illustrations.

{% capture html -%}
<div>
  <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 800 600">
    <path
      d="M165.042 305.17C165.042 347.031 209.306 377.394 228.857 411.189C249.036 446.056 253.885 499.359 288.752 519.524C322.561 539.075 370.672 517.207 412.534 517.207C454.395 517.207 502.506 539.075 536.301 519.524C571.168 499.359 576.017 446.056 596.196 411.189C615.747 377.394 660.011 347.031 660.011 305.17C660.011 263.309 615.747 232.961 596.196 199.166C576.017 164.298 571.168 110.996 536.301 90.8302C502.506 71.2798 454.38 93.1471 412.534 93.1471C370.687 93.1471 322.561 71.2798 288.752 90.8302C253.885 110.996 249.036 164.298 228.857 199.166C209.306 232.961 165.042 263.323 165.042 305.17Z"
      fill="black"
      opacity="0.07"
    />
    <path
      d="M375.492 479.923C470.481 479.923 547.485 476.824 547.485 473.001C547.485 469.178 470.481 466.079 375.492 466.079C280.503 466.079 203.5 469.178 203.5 473.001C203.5 476.824 280.503 479.923 375.492 479.923Z"
      fill="black"
      opacity="0.26"
    />
    <path
      d="M511.988 174.667C493.855 167.122 474.216 163.9 454.624 165.256L456.64 177.084L511.988 174.667Z"
      fill="#0455A4"
      style="fill: #0455a4; fill: var(--tblr-primary, var(--tblr-illustrations-primary, #0455a4))"
    />
    <path
      d="M518.452 301.638L572.584 329.197L591.949 299.006L602.918 281.844C608.639 272.891 617.062 260.034 627.674 244.159C626.096 241.199 624.176 238.434 621.954 235.921C616.989 230.419 610.739 226.233 603.762 223.736H603.633C599.858 222.306 595.996 221.019 592.192 219.674C585.755 217.369 579.457 214.695 573.328 211.665C568.623 209.377 563.545 206.66 558.154 203.428C555.15 210.807 552.161 218.187 549.187 225.567C543.466 239.868 537.697 254.132 531.881 268.357C527.419 279.465 522.943 290.558 518.452 301.638Z"
      fill="#DADCE0"
    />
    <path
      d="M573.328 211.665L580.908 225.338L581.866 225.567C589.204 227.065 596.817 226.429 603.805 223.736H603.676C599.9 222.306 596.039 221.019 592.235 219.674C585.784 217.371 579.471 214.697 573.328 211.665Z"
      fill="#FFCB9D"
      style="fill: #ffcb9d; fill: var(--tblr-illustrations-skin, #ffcb9d)"
    />
    <path
      d="M627.674 244.216C617.062 260.091 608.696 272.948 602.918 281.901C601.087 284.762 599.757 286.807 594.509 295.016L591.949 299.006L582.738 313.308L572.584 329.14L518.466 301.623C522.929 290.563 527.405 279.494 531.896 268.415L549.186 225.638C549.287 225.409 549.372 225.181 549.473 224.966C551.379 220.132 553.329 215.303 555.322 210.478C556.275 208.152 557.229 205.816 558.182 203.471C561.171 205.287 564.089 206.917 566.878 208.405C569.109 209.606 571.268 210.707 573.356 211.737C579.485 214.732 585.778 217.377 592.206 219.66C596.01 221.004 599.872 222.234 603.647 223.722H603.776C604.649 224.079 605.521 224.423 606.365 224.823C612.359 227.307 617.709 231.121 622.011 235.978C624.21 238.497 626.11 241.261 627.674 244.216Z"
      fill="#0455A4"
      style="fill: #0455a4; fill: var(--tblr-primary, var(--tblr-illustrations-primary, #0455a4))"
    />
    <path
      d="M600.816 220.246C592.32 224.537 585.441 224.852 580.507 224.165C580.221 224.165 579.949 224.094 579.678 224.036L572.069 212.595C578.203 212.59 584.3 213.555 590.132 215.455C593.844 216.693 597.423 218.298 600.816 220.246Z"
      fill="#FFCB9D"
      style="fill: #ffcb9d; fill: var(--tblr-illustrations-skin, #ffcb9d)"
    />
    <path
      d="M191.729 429.895L559.226 429.895C571.011 429.895 580.564 420.342 580.564 408.557V198.408C580.564 186.623 571.011 177.07 559.226 177.07L191.729 177.07C179.945 177.07 170.391 186.623 170.391 198.408V408.557C170.391 420.342 179.945 429.895 191.729 429.895Z"
      fill="#232B41"
    />
    <path
      d="M585.584 197.736C585.395 190.871 582.537 184.35 577.619 179.557C572.701 174.764 566.108 172.076 559.241 172.064H191.686C184.702 172.072 178.006 174.849 173.067 179.788C168.128 184.727 165.35 191.423 165.343 198.408V408.643C165.35 415.628 168.128 422.324 173.067 427.262C178.006 432.201 184.702 434.979 191.686 434.987H326.008V443.94C324.578 453.679 318.042 456.425 313.466 457.126H262.537C261.503 457.13 260.512 457.542 259.78 458.274C259.049 459.005 258.637 459.996 258.633 461.03V465.55C258.637 466.584 259.049 467.575 259.78 468.306C260.512 469.038 261.503 469.45 262.537 469.454H488.504C489.017 469.454 489.525 469.353 489.998 469.157C490.472 468.961 490.903 468.673 491.265 468.31C491.628 467.948 491.915 467.517 492.111 467.044C492.308 466.57 492.409 466.062 492.409 465.55V461.03C492.409 460.517 492.308 460.01 492.111 459.536C491.915 459.062 491.628 458.632 491.265 458.269C490.903 457.907 490.472 457.619 489.998 457.423C489.525 457.227 489.017 457.126 488.504 457.126H437.476C432.899 456.425 426.306 453.665 424.933 443.868V434.915H559.241C566.226 434.908 572.924 432.13 577.865 427.192C582.806 422.254 585.587 415.557 585.599 408.572V198.336C585.599 198.179 585.599 197.964 585.584 197.736ZM575.573 408.572C575.569 412.898 573.849 417.047 570.789 420.106C567.73 423.166 563.582 424.886 559.255 424.89H191.701C187.374 424.886 183.226 423.166 180.166 420.106C177.107 417.047 175.386 412.898 175.382 408.572V198.336C175.386 194.01 177.107 189.861 180.166 186.802C183.226 183.742 187.374 182.022 191.701 182.018H559.255C561.484 182.012 563.691 182.469 565.734 183.362C568.656 184.626 571.144 186.717 572.892 189.378C574.641 192.039 575.573 195.153 575.573 198.336V408.572Z"
      fill="#444B5E"
    />
    <path
      d="M211.108 222.706L443.454 222.706C444.497 222.706 445.342 221.861 445.342 220.819V214.798C445.342 213.755 444.497 212.91 443.454 212.91L211.108 212.91C210.066 212.91 209.22 213.755 209.22 214.798V220.819C209.22 221.861 210.066 222.706 211.108 222.706Z"
      fill="#0455A4"
      style="fill: #0455a4; fill: var(--tblr-primary, var(--tblr-illustrations-primary, #0455a4))"
    />
    <path
      d="M211.094 314.981H252.111C253.146 314.981 253.985 314.142 253.985 313.108V307.058C253.985 306.023 253.146 305.184 252.111 305.184H211.094C210.059 305.184 209.22 306.023 209.22 307.058V313.108C209.22 314.142 210.059 314.981 211.094 314.981Z"
      fill="#DADCE0"
    />
    <path
      d="M211.809 279.856H368.971C370.4 279.856 371.559 278.697 371.559 277.267V250.595C371.559 249.165 370.4 248.006 368.971 248.006L211.809 248.006C210.379 248.006 209.22 249.165 209.22 250.595V277.267C209.22 278.697 210.379 279.856 211.809 279.856Z"
      fill="#A7AAB3"
    />
    <path
      d="M389.479 335.733L382.271 326.78L363.822 341.611L346.56 320.144L331.586 332.2L348.848 353.667L330.399 368.498L337.593 377.465L356.042 362.62L373.304 384.087L388.292 372.031L371.03 350.564L389.479 335.733Z"
      fill="#0455A4"
      style="fill: #0455a4; fill: var(--tblr-primary, var(--tblr-illustrations-primary, #0455a4))"
    />
    <path
      d="M591.934 268.701C593.522 258.689 602.961 233.776 606.393 224.895C605.55 224.494 604.677 224.151 603.805 223.793H603.676C597.784 223.936 594.695 223.45 594.451 222.363C594.266 221.548 595.567 220.418 598.356 218.945C595.969 217.727 593.498 216.68 590.962 215.813C589.216 215.204 587.44 214.684 585.642 214.254L585.413 309.389C587.615 305.957 589.818 302.539 592.006 299.106L594.566 295.116C592.635 286.034 590.919 275.094 591.934 268.701ZM485.401 254.857C484.8 254.942 484.114 259.376 486.288 262.208C486.835 262.909 487.534 263.476 488.333 263.867C487.189 258.861 486.002 254.785 485.401 254.857ZM507.354 307.487C505.774 306.55 504.119 305.747 502.406 305.084C503.966 306.056 505.625 306.862 507.354 307.487ZM469.283 332.115L465.765 355.569L469.583 349.491C469.14 343.71 469.039 337.908 469.283 332.115ZM514.004 331.385C514.763 329.722 515.32 327.975 515.663 326.179C506.08 322.786 496.693 318.861 487.546 314.423C485.44 321.176 482.706 327.717 479.38 333.959L469.583 349.534C469.755 351.293 469.984 353.038 470.298 354.711C472.043 364.122 476.219 370.586 479.408 375.535C485.661 385.147 494.013 393.215 503.836 399.132C530.306 400.116 556.093 390.607 575.588 372.674V364.994L514.004 331.385Z"
      fill="black"
      opacity="0.1"
    />
    <path
      d="M514.376 314.638C512.764 311.667 510.325 309.227 507.354 307.616C505.625 306.99 503.966 306.185 502.406 305.213L502.148 305.084C502.148 305.084 502.248 305.084 502.406 305.213C504.119 305.875 505.774 306.679 507.354 307.616C507.997 307.787 508.527 307.802 508.784 307.53C510.1 306.243 503.478 300.451 502.005 290.783C501.633 288.251 500.761 282.502 504.05 277.182C508.169 270.517 515.935 269.244 517.422 269.015C511.358 267.019 505.07 265.785 498.701 265.34C494.411 265.039 490.835 265.182 488.318 263.91C489.348 268.372 490.349 273.549 490.864 277.153C492.515 289.684 491.377 302.426 487.532 314.466C496.679 318.904 506.065 322.829 515.649 326.222C516.477 322.324 516.031 318.263 514.376 314.638ZM585.584 175.096V229.042C582.59 228.905 579.63 228.351 576.789 227.397C565.562 223.564 557.567 213.668 557.567 202.069C557.567 190.47 565.562 180.616 576.789 176.741C579.63 175.787 582.59 175.233 585.584 175.096Z"
      fill="black"
      opacity="0.1"
    />
    <path
      d="M585.57 222.935L609.483 216.128L613.501 223.278L588.974 239.868C587.815 237.194 586.643 234.505 585.484 231.817C585.556 228.827 585.556 225.967 585.57 222.935Z"
      fill="#DADCE0"
    />
    <path
      d="M585.584 175.096V229.042C582.59 228.905 579.63 228.351 576.789 227.397L575.559 226.954V198.351C575.558 195.167 574.626 192.053 572.878 189.392C571.13 186.732 568.641 184.641 565.719 183.377C568.431 180.786 571.61 178.733 575.087 177.327C575.645 177.098 576.217 176.884 576.789 176.683C579.633 175.749 582.593 175.215 585.584 175.096Z"
      fill="black"
      opacity="0.15"
    />
    <path
      d="M610.198 137.454C611.056 141.973 612.186 148.609 613.358 156.818C613.587 158.62 613.816 160.194 613.902 160.737C614.881 169.779 614.722 178.908 613.43 187.91C613.144 189.698 612.843 191.4 612.429 193.073C611.299 197.707 600.287 205.258 587.072 209.706C582.519 211.261 577.817 212.34 573.042 212.924C558.182 214.712 548.414 204.586 548.343 195.762C548.293 193.608 548.896 191.488 550.073 189.684C552.13 186.006 553.496 181.983 554.106 177.813C555.126 172.287 555.748 166.695 555.966 161.08C556.166 157.877 556.151 155.789 556.151 155.789L567.593 140.214L601.845 132.348C602.761 138.197 605.178 141.844 607.066 141.787C608.953 141.73 609.955 138.212 610.198 137.454Z"
      fill="#FFCB9D"
      style="fill: #ffcb9d; fill: var(--tblr-illustrations-skin, #ffcb9d)"
    />
    <path
      d="M610.198 137.454C611.041 141.973 612.185 148.609 613.373 156.818C613.587 158.62 613.816 160.208 613.887 160.737C614.877 169.778 614.728 178.907 613.444 187.91C611.07 187.716 608.754 187.071 606.622 186.008C604.293 184.813 602.223 183.171 600.53 181.174C598.789 179.022 597.399 176.608 596.411 174.023C595.671 172.382 595.036 170.696 594.509 168.975C582.401 176.336 568.178 179.433 554.106 177.77C555.126 172.244 555.747 166.652 555.965 161.037C556.166 157.834 556.151 155.731 556.151 155.731L567.593 140.171L601.845 132.348C602.761 138.197 605.178 141.844 607.065 141.773C608.953 141.701 610.026 138.212 610.269 137.482"
      fill="black"
      opacity="0.1"
    />
    <path
      d="M616.147 143.804C617.621 150.946 616.333 158.382 612.543 164.613C611.699 165.705 610.934 166.857 610.255 168.059C608.586 171.497 607.8 175.297 607.967 179.115C605.963 177.555 604.47 175.434 603.676 173.022C602.575 169.318 602.618 161.996 602.475 161.009V160.408C602.475 160.079 602.389 159.636 602.275 158.778C601.977 156.941 601.562 155.126 601.03 153.343C601.023 153.249 600.988 153.16 600.93 153.086C593.479 160.322 571.769 178.829 552.304 169.962C549.27 168.595 546.452 166.793 543.938 164.613C543.696 164.444 543.479 164.242 543.294 164.012C542.682 163.466 542.104 162.884 541.564 162.267L541.406 162.11C540.013 160.506 538.892 158.685 538.088 156.718L537.488 155.889C537.211 155.006 537.005 154.102 536.873 153.186C536.555 149.566 537.5 145.948 539.547 142.946C543.251 137.068 549.701 132.62 553.105 130.303C566.291 121.136 588.001 114.728 603.505 124.983C607.42 127.703 610.643 131.303 612.915 135.494C614.324 138.117 615.359 140.923 615.99 143.832"
      fill="#444B5E"
    />
    <path
      d="M600.744 153.028C593.293 160.265 571.583 178.771 552.118 169.904C549.084 168.538 546.266 166.736 543.752 164.556C543.51 164.387 543.293 164.185 543.108 163.955C542.496 163.409 541.918 162.827 541.378 162.21L541.22 162.053C539.83 160.447 538.71 158.626 537.902 156.661C542.634 159.548 547.809 161.635 553.22 162.839C580.007 168.674 602.146 148.724 605.678 145.534L605.95 145.291C604.428 148.012 602.707 150.618 600.801 153.086"
      fill="black"
      opacity="0.3"
    />
    <path
      d="M483.942 177.727C483.944 179.167 483.81 180.604 483.542 182.018H457.484C457.216 180.604 457.082 179.167 457.083 177.727C457.072 175.8 457.298 173.879 457.756 172.007H483.284C483.729 173.881 483.95 175.801 483.942 177.727Z"
      fill="black"
      opacity="0.15"
    />
    <path
      d="M466.422 169.089C467.695 170.426 468.769 171.938 469.612 173.58C472.744 179.386 472.315 185.679 468.053 189.169C462.618 193.559 453.165 191.729 446.872 185.064C446.186 184.326 445.55 183.543 444.97 182.719C440.493 176.412 440.451 168.875 445.256 164.999C450.633 160.594 460.144 162.425 466.422 169.089Z"
      fill="#FFCB9D"
      style="fill: #ffcb9d; fill: var(--tblr-illustrations-skin, #ffcb9d)"
    />
    <path
      d="M466.422 169.089C467.695 170.426 468.769 171.938 469.612 173.58C469.011 173.98 468.468 174.338 467.881 174.695C460.144 179.344 455.167 178.385 446.114 182.161C445.722 182.324 445.34 182.51 444.97 182.719C440.493 176.412 440.451 168.875 445.256 164.999C450.633 160.594 460.144 162.425 466.422 169.089Z"
      fill="black"
      opacity="0.1"
    />
    <path
      d="M585.599 343.356V364.107L575.588 372.688V346.817L585.384 342.197L585.599 343.356Z"
      fill="black"
      opacity="0.15"
    />
    <path
      d="M520.025 263.695C518.559 268.03 515.781 271.802 512.076 274.488C508.37 277.173 503.921 278.64 499.345 278.683L483.141 326.766L476.205 347.274L473.273 355.927C476.717 358.617 479.284 362.269 480.65 366.42C482.016 370.571 482.119 375.034 480.946 379.243C479.772 383.452 477.376 387.219 474.059 390.064C470.743 392.91 466.657 394.707 462.318 395.228L469.04 375.377C469.299 374.598 469.24 373.747 468.876 373.011C468.512 372.274 467.872 371.711 467.095 371.444L454.967 367.34C454.187 367.08 453.337 367.139 452.6 367.503C451.864 367.867 451.301 368.508 451.034 369.285L444.326 389.135C441.191 386.09 439.031 382.181 438.122 377.905C437.212 373.629 437.594 369.179 439.219 365.121C440.843 361.063 443.637 357.579 447.246 355.112C450.855 352.644 455.115 351.305 459.486 351.265L462.347 342.941L469.412 322.046L485.573 274.021C482.129 271.331 479.561 267.679 478.195 263.528C476.829 259.377 476.726 254.914 477.9 250.705C479.073 246.495 481.47 242.729 484.786 239.883C488.102 237.038 492.189 235.24 496.528 234.72L489.806 254.571C489.673 254.956 489.619 255.365 489.645 255.772C489.671 256.179 489.778 256.577 489.959 256.942C490.14 257.308 490.391 257.634 490.699 257.902C491.006 258.17 491.364 258.375 491.751 258.504L503.864 262.608C504.644 262.868 505.494 262.809 506.231 262.445C506.967 262.08 507.53 261.44 507.797 260.663L514.519 240.812C517.507 243.715 519.611 247.406 520.585 251.457C521.56 255.507 521.366 259.751 520.025 263.695Z"
      fill="#A7AAB3"
    />
    <path
      d="M483.141 326.766L476.205 347.274C473.637 346.92 471.106 346.341 468.639 345.544C466.472 344.831 464.359 343.961 462.318 342.941L469.383 322.046C471.541 322.405 473.668 322.926 475.747 323.605C478.306 324.422 480.782 325.48 483.141 326.766Z"
      fill="black"
      opacity="0.1"
    />
    <path
      d="M477.421 302.581C474.667 302.666 471.941 303.148 469.326 304.012C459.915 306.872 453.765 314.023 454.638 322.175C455.782 332.544 467.738 340.524 481.396 340.052C482.907 339.986 484.412 339.823 485.901 339.566C497.257 337.549 505.209 329.555 504.179 320.459C503.063 310.147 491.05 302.11 477.421 302.581Z"
      fill="#FFCB9D"
      style="fill: #ffcb9d; fill: var(--tblr-illustrations-skin, #ffcb9d)"
    />
    <path
      d="M477.42 302.581C474.667 302.666 471.941 303.148 469.326 304.012C469.555 305.07 469.755 306.014 470.012 307.001C473.344 320.058 479.623 324.263 485.244 337.764C485.499 338.35 485.719 338.952 485.901 339.566C497.257 337.549 505.209 329.555 504.179 320.459C503.063 310.147 491.05 302.11 477.42 302.581Z"
      fill="black"
      opacity="0.1"
    />
    <path
      d="M640.36 287.951C638.93 310.59 624.628 332.93 601.002 350.178C579.177 366.095 549.387 377.694 514.39 381.184C508.167 370.155 502.23 358.967 496.585 347.632C494.726 343.928 492.909 340.181 491.079 336.362C483.928 321.46 477.664 307.044 472.129 293.271C487.689 298.377 551.975 318.442 589.932 302.152C596.811 299.206 610.541 293.4 612.486 282.13C613.048 278.08 612.317 273.956 610.398 270.345C608.798 267.347 607.829 264.053 607.55 260.666C607.271 257.279 607.688 253.871 608.776 250.652C609.864 247.432 611.599 244.469 613.875 241.946C616.152 239.422 618.92 237.392 622.011 235.978C640.46 260.177 640.86 279.87 640.36 287.951Z"
      fill="#0455A4"
      style="fill: #0455a4; fill: var(--tblr-primary, var(--tblr-illustrations-primary, #0455a4))"
    />
    <path
      d="M601.002 350.178C579.177 366.095 549.387 377.694 514.39 381.184C511.347 375.792 508.372 370.361 505.466 364.894C501.376 357.2 497.519 349.634 493.896 342.197C505.942 349.292 519.121 354.256 532.854 356.871C555.749 361.042 579.355 358.723 601.002 350.178Z"
      fill="black"
      opacity="0.1"
    />
  </svg>
</div>
{%- endcapture %}
{% include "docs/example.html" html=html %}

## Autodark mode

Tabler Illustrations supports autodark mode, which automatically switches the color scheme of the illustrations based on the user's system preferences. To enable autodark mode, copy illustration code from the `svg-css-autodark` folder.

Illustrations change theme based on the user's system preferences or `data-bs-theme` attribute or `theme` class.

```html
<html data-bs-theme="dark">
  <body>
    <svg>...</svg>
  </body>
</html>
```

Look at the example below to see how the illustration changes based on the user's system preferences.

{% capture html -%}
<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 800 600">
  <style>
    :where(.theme-dark, [data-bs-theme="dark"]) .tblr-illustrations-boy-girl-a {
      fill: black;
      opacity: 0.07;
    }
    :where(.theme-dark, [data-bs-theme="dark"]) .tblr-illustrations-boy-girl-b {
      fill: #1a2030;
    }
    :where(.theme-dark, [data-bs-theme="dark"]) .tblr-illustrations-boy-girl-c {
      fill: #454c5e;
    }
    @media (prefers-color-scheme: dark) {
      .tblr-illustrations-boy-girl-a {
        fill: black;
        opacity: 0.07;
      }
      .tblr-illustrations-boy-girl-b {
        fill: #1a2030;
      }
      .tblr-illustrations-boy-girl-c {
        fill: #454c5e;
      }
    }
  </style>
  <path
    d="M658.744 282.266C658.744 325.973 612.535 357.656 592.114 392.937C571.053 429.346 565.991 484.976 529.581 506.037C494.299 526.458 444.065 503.618 400.367 503.618C356.669 503.618 306.435 526.458 271.153 506.037C234.753 484.976 229.681 429.346 208.62 392.937C188.209 357.656 142 325.953 142 282.266C142 238.579 188.209 206.865 208.62 171.584C229.681 135.185 234.753 79.5143 271.153 58.4839C306.435 38.0736 356.669 60.9031 400.367 60.9031C444.065 60.9031 494.299 38.0736 529.581 58.4839C565.991 79.5448 571.053 135.185 592.114 171.584C612.535 206.865 658.744 238.568 658.744 282.266Z"
    fill="#F7F8FC"
    class="tblr-illustrations-boy-girl-a"
  />
  <path
    d="M397.248 550C534.459 550 645.689 545.836 645.689 540.7C645.689 535.564 534.459 531.401 397.248 531.401C260.038 531.401 148.808 535.564 148.808 540.7C148.808 545.836 260.038 550 397.248 550Z"
    fill="#A6A9B3"
    class="tblr-illustrations-boy-girl-b"
  />
  <path
    d="M479.179 238.829C475.497 244.691 456.146 274.402 421.211 280.161C408.559 282.198 395.593 280.84 383.637 276.225C376.963 273.704 370.647 270.322 364.85 266.164L373.304 245.592C374.244 246.41 375.7 247.659 377.607 249.049C384.182 253.84 395.868 260.321 407.863 256.273C414.608 254.009 419.323 249.697 428.36 240.849C436.25 233.084 443.39 224.592 449.683 215.486C455.319 205.153 466.977 202.626 474.943 209.512C482.598 215.974 484.609 229.097 479.179 238.829Z"
    fill="#FFCB9D"
    style="fill: #ffcb9d; fill: var(--tblr-illustrations-skin, #ffcb9d)"
  />
  <path
    d="M383.666 276.159C376.992 273.638 370.676 270.256 364.879 266.098L373.333 245.526C374.272 246.344 375.728 247.593 377.635 248.983C377.119 253.445 376.818 260.697 379.035 266.568C380.328 269.88 381.876 273.087 383.666 276.159Z"
    fill="black"
    opacity="0.15"
  />
  <path
    d="M324.054 160.289C332.183 175.733 345.737 187.624 362.107 193.674L307.502 198.718C313.026 185.906 318.543 173.096 324.054 160.289Z"
    fill="#232B41"
    class="tblr-illustrations-boy-girl-c"
  />
  <path
    d="M302.083 425.902L299.434 457.398L295.601 503.211H291.872L282.206 455.679L278.073 435.333L302.083 425.902ZM355.701 425.902L353.221 455.548L349.229 503.211H345.5L336.153 457.314L331.682 435.333L355.701 425.902Z"
    fill="#DADBE0"
  />
  <path
    d="M278.063 435.333L302.083 425.939L299.434 457.436C293.46 457.051 287.692 456.496 282.206 455.717L278.063 435.333ZM355.701 425.902L353.212 455.548C347.782 456.318 342.071 456.91 336.153 457.314L331.682 435.333L355.701 425.902Z"
    fill="black"
    opacity="0.15"
  />
  <path
    d="M318.108 202.692C302.571 204.392 285.231 199.874 278.063 195.017C276.833 194.294 275.8 193.278 275.057 192.058C274.278 190.508 273.592 188.902 272.916 187.202C271.976 184.872 271.169 182.449 270.445 180.025C268.518 173.72 267.17 167.252 266.415 160.703C266.415 160.167 266.218 158.57 266.021 156.72C265.345 148.425 265.006 141.69 264.809 137.069C265.204 137.745 267.139 140.901 268.886 140.61C270.765 140.225 272.333 136.092 271.901 130.174H307.136L321.847 142.893C321.847 142.893 322.279 144.931 323.199 148.031C324.69 153.477 326.558 158.813 328.789 164C330.667 168.321 332.912 172.304 335.364 174.727C343.49 182.468 336.745 200.747 318.108 202.692Z"
    fill="#FFCB9D"
    style="fill: #ffcb9d; fill: var(--tblr-illustrations-skin, #ffcb9d)"
  />
  <path
    d="M328.788 164C315.373 168.775 300.746 168.931 287.231 164.441C283.781 164.927 280.531 166.354 277.838 168.565C273.855 171.919 273.958 175.018 270.755 179.584L270.464 180.025C268.537 173.72 267.188 167.252 266.434 160.703C266.434 160.167 266.237 158.57 266.039 156.72C265.363 148.425 265.025 141.69 264.828 137.069C265.222 137.745 267.157 140.901 268.904 140.61C270.783 140.225 272.352 136.092 271.92 130.174H307.155L321.865 142.893C321.865 142.893 322.297 144.931 323.218 148.031C324.703 153.476 326.564 158.812 328.788 164Z"
    fill="black"
    opacity="0.1"
  />
  <path
    d="M353.502 268.466C356.893 286.755 359.298 300.197 360.951 309.666C361.045 310.192 361.13 310.718 361.224 311.244C363.196 322.244 365.225 333.253 367.198 344.272C330.2 344.935 293.193 345.649 256.176 346.413C256.232 343.868 256.27 341.238 256.335 338.673V338.542C255.228 310.418 255.658 282.255 257.622 254.178C257.763 252.102 257.913 250.045 258.083 247.978L252.54 260.923L230.334 247.772C231.132 244.258 233.922 233.681 242.132 226.448C242.132 226.448 249.581 219.967 257.895 218.792C258.667 218.721 259.432 218.596 260.187 218.417C260.319 218.382 260.454 218.357 260.591 218.342C265.334 217.665 269.928 217.055 274.249 216.726C284.754 215.813 295.312 215.656 305.839 216.256C315.93 216.869 325.952 218.314 335.805 220.577C338.285 221.169 340.868 221.845 343.32 222.653L345.405 223.358C345.668 223.442 345.922 223.517 346.166 223.611L347.537 224.109C349.097 224.71 364.606 229.229 368.006 230.271C371.821 231.512 375.321 233.566 378.264 236.293L364.089 275.464L353.502 268.466Z"
    fill="#0455A4"
    style="fill: #0455a4; fill: var(--tblr-illustrations-primary, var(--tblr-primary, #0455a4))"
  />
  <path
    d="M271.554 222.127C271.554 233.832 285.644 243.3 303.069 243.3C320.494 243.3 334.519 233.832 334.519 222.127C334.52 221.496 334.457 220.867 334.331 220.249C324.476 217.949 314.441 216.504 304.337 215.927C293.815 215.329 283.263 215.495 272.765 216.425C271.953 218.216 271.539 220.161 271.554 222.127Z"
    fill="#FFCB9D"
    style="fill: #ffcb9d; fill: var(--tblr-illustrations-skin, #ffcb9d)"
  />
  <path
    d="M337.524 142.451C335.044 147.89 329.361 151.845 328.591 152.361C312.133 163.511 287.334 150.849 280.684 147.063C279.03 151.572 274.756 154.973 274.221 157.744C274.08 158.57 273.939 159.397 273.836 160.167C273.671 161.504 273.593 162.85 273.601 164.197C273.65 166.483 273.908 168.759 274.371 170.998C275.188 174.887 278.664 185.22 284.347 198.681C276.388 199.207 268.422 199.742 260.45 200.287L241.108 201.583C238.404 192.37 237.788 182.669 239.305 173.187C239.446 172.341 239.671 171.101 240.009 169.551C240.72 166.396 241.662 163.297 242.827 160.28C243.034 159.754 243.26 159.209 243.485 158.664C245.146 154.767 247.194 151.047 249.6 147.561C255.842 138.551 264.069 131.095 273.648 125.768C276.945 124.04 298.071 113.19 319.563 120.808C324.908 122.687 337.618 127.262 338.689 136.148C338.907 138.317 338.503 140.503 337.524 142.451ZM291.204 514.539C285.803 516.324 285.718 525.182 285.718 525.182L284.253 534.219L294.68 536.68L297.658 529.578L316.905 536.68C312.885 527.38 296.615 512.764 291.204 514.539ZM368.72 536.68C364.69 527.38 348.42 512.764 343.019 514.539C337.618 516.315 337.524 525.182 337.524 525.182L336.068 534.219L346.476 536.68L349.454 529.578L368.72 536.68Z"
    fill="#232B41"
    class="tblr-illustrations-boy-girl-c"
  />
  <path
    d="M337.524 142.451C335.044 147.89 329.371 151.845 328.591 152.352C312.133 163.521 287.335 150.849 280.684 147.063C278.366 144.912 276.281 142.523 274.465 139.934C283.982 145.468 294.71 148.587 305.711 149.018C316.712 149.448 327.651 147.178 337.571 142.404L337.524 142.451Z"
    fill="black"
    opacity="0.3"
  />
  <path
    d="M373.051 435.333H258.947L256.956 371.738L256.176 346.423L367.199 344.262L371.942 418.002L373.051 435.333Z"
    fill="#A6A9B3"
  />
  <path
    d="M373.05 435.333H258.947L257.632 345.615L313.392 345.249C292.67 386.214 286.602 401.469 288.274 402.85C290.566 404.729 306.121 379.122 314.003 383.527C316.868 385.134 317.168 389.849 317.985 393.005C320.531 402.756 332.226 413.455 371.942 418.002L373.05 435.333Z"
    fill="black"
    opacity="0.1"
  />
  <path
    d="M346.241 223.63H346.194L345.433 223.386C342.371 236.997 324.552 247.48 303.087 247.48C279.425 247.48 260.177 234.799 260.177 219.225V218.436C259.454 218.548 258.693 218.67 257.904 218.821C257.895 218.955 257.895 219.09 257.904 219.225C257.904 236.283 278.166 250.223 303.087 250.223C325.51 250.223 344.156 238.951 347.603 224.194L346.241 223.63Z"
    fill="#E1E1E1"
  />
  <path
    d="M307.502 263.853C309.411 263.853 310.959 262.011 310.959 259.739C310.959 257.467 309.411 255.625 307.502 255.625C305.593 255.625 304.045 257.467 304.045 259.739C304.045 262.011 305.593 263.853 307.502 263.853Z"
    fill="#E1E1E1"
  />
  <path
    d="M260.404 200.315L241.063 201.612C238.358 192.398 237.742 182.697 239.259 173.215C239.4 172.37 239.625 171.13 239.964 169.58L242.782 160.308C242.988 159.782 243.214 159.237 243.439 158.693C245.1 154.796 247.148 151.076 249.554 147.589C248.615 159.989 248.474 177.273 253.744 188.263C255.706 192.418 257.931 196.443 260.404 200.315Z"
    fill="black"
    opacity="0.3"
  />
  <path
    d="M367.199 344.272C330.201 344.935 293.193 345.649 256.176 346.413C256.233 343.868 256.27 341.238 256.336 338.673V338.542C315.929 341.501 350.957 319.557 361.224 311.244C363.197 322.244 365.264 333.253 367.199 344.272Z"
    fill="black"
    opacity="0.1"
  />
  <path
    d="M280.017 380.052C274.531 389.041 263.503 391.437 255.35 384.965C250.399 380.597 225.45 357.564 220.594 316.006C218.13 294.148 221.708 272.032 230.936 252.064C231.509 250.843 232.007 249.829 232.429 249.002L249.723 259.119C249.103 260.124 248.173 261.674 247.13 263.637C243.063 271.34 237.267 285.609 240.743 300.272C242.621 308.276 246.266 313.912 253.706 324.695C259.993 333.807 267.133 342.299 275.029 350.058C283.671 356.662 285.804 370.564 280.017 380.052Z"
    fill="#FFCB9D"
    style="fill: #ffcb9d; fill: var(--tblr-illustrations-skin, #ffcb9d)"
  />
  <path
    d="M249.723 259.119C249.103 260.124 248.173 261.674 247.13 263.637C242.33 260.274 234.862 255.005 230.926 252.064C231.499 250.843 231.997 249.829 232.42 249.002L249.723 259.119Z"
    fill="black"
    opacity="0.15"
  />
  <path
    d="M304.337 215.899C293.815 215.301 283.264 215.467 272.766 216.397C271.949 218.196 271.536 220.152 271.554 222.127C271.554 233.832 285.644 243.3 303.069 243.3C320.494 243.3 334.519 233.832 334.519 222.127C334.52 221.496 334.457 220.867 334.331 220.248C324.477 217.94 314.442 216.485 304.337 215.899Z"
    fill="black"
    opacity="0.07"
  />
  <path
    d="M445.325 188.01C446.283 199.188 447.25 210.351 448.227 221.498L453.863 286.182C455.329 302.909 456.785 319.645 458.231 336.39H543.713C545.372 319.639 547.038 302.902 548.71 286.182C549.668 276.701 550.608 267.223 551.528 257.748C553.852 234.489 556.162 211.243 558.461 188.01H445.325Z"
    fill="#DADBE0"
  />
  <path
    d="M555.464 217.844C547.072 224.328 539.267 231.538 532.14 239.393C515.429 257.766 513.109 267.62 505.171 271.03C495.956 274.994 479.809 269.997 449.542 228.045L453.995 288.474H454.042C455.445 304.443 456.835 320.412 458.213 336.381H543.694C545.354 319.642 547.019 302.909 548.692 286.182H549.058L555.464 217.844Z"
    fill="black"
    opacity="0.1"
  />
  <path
    d="M420.385 276.76C422.47 282.504 425.273 287.961 428.727 293.002C429.744 294.46 430.829 295.871 431.977 297.229C436.998 303.248 443.375 307.99 450.585 311.065C454.275 312.632 458.128 313.779 462.074 314.485C467.561 315.468 473.147 315.784 478.71 315.424C479.17 315.424 479.649 315.377 480.072 315.34C480.247 315.35 480.423 315.35 480.598 315.34L481.631 315.255L482.12 315.208H482.458C486.709 314.762 490.926 314.037 495.083 313.038H495.148C498.827 312.155 502.453 311.064 506.007 309.769C507.604 309.215 509.145 308.604 510.62 307.956C512.674 307.067 514.615 306.128 516.444 305.138C519.749 303.381 522.934 301.407 525.978 299.23C527.35 298.243 528.608 297.294 529.736 296.411C522.502 293.161 515.26 289.892 508.018 286.661C503.784 284.782 499.557 282.882 495.336 280.959C493.604 282.328 491.712 283.479 489.7 284.388C488.168 285.069 486.55 285.537 484.891 285.778C483.818 285.965 482.727 286.028 481.64 285.966C478.4 285.778 475.347 284.181 472.51 281.617C472.363 281.502 472.225 281.376 472.097 281.241C470.798 280.007 469.592 278.679 468.489 277.267C456.841 262.407 449.702 233.681 449.702 233.681C452.924 222.879 453.119 211.399 450.266 200.494C449.097 196.178 447.436 192.011 445.316 188.076C440.947 188.898 436.792 190.601 433.104 193.082C431.175 194.4 429.398 195.928 427.806 197.638C412.607 213.861 410.268 249.528 420.385 276.76Z"
    fill="#DADBE0"
  />
  <path
    d="M445.325 188.01C438.625 189.246 432.498 192.598 427.844 197.572C412.607 213.861 410.268 249.528 420.385 276.76C422.47 282.504 425.273 287.961 428.727 293.002C429.744 294.46 430.828 295.871 431.977 297.229C436.998 303.248 443.375 307.99 450.585 311.065C452.425 311.844 454.306 312.518 456.221 313.085L458.26 336.39H543.741C545.401 319.639 547.067 302.902 548.739 286.182C549.697 276.694 550.636 267.216 551.557 257.748C553.861 234.489 556.163 211.243 558.461 188.01H445.325Z"
    fill="black"
    opacity="0.05"
  />
  <path
    d="M540.181 104.661C540.002 109.282 539.636 116.055 538.95 124.387C538.762 126.266 538.621 127.816 538.584 128.37C537.518 137.473 535.309 146.404 532.008 154.954C531.322 156.654 530.637 158.251 529.857 159.81C526.973 165.578 505.434 172.529 486.703 170.472C467.972 168.415 461.256 150.201 469.353 142.413C471.824 139.99 474.116 136.007 475.994 131.667C478.228 126.463 480.092 121.108 481.574 115.642C482.513 112.533 482.946 110.475 482.946 110.475L497.712 97.7471H533.041C532.628 103.703 534.187 107.817 536.057 108.183C537.926 108.55 539.767 105.346 540.181 104.661Z"
    fill="#FFCB9D"
    style="fill: #ffcb9d; fill: var(--tblr-illustrations-skin, #ffcb9d)"
  />
  <path
    d="M540.181 104.661C540.002 109.282 539.636 116.055 538.95 124.387C538.762 126.266 538.621 127.816 538.584 128.37C537.519 137.473 535.309 146.404 532.008 154.954C529.719 154.235 527.589 153.083 525.734 151.563C523.719 149.859 522.057 147.779 520.839 145.438C519.612 142.93 518.785 140.246 518.388 137.482C518.04 135.703 517.795 133.906 517.655 132.099C504.109 136.607 489.444 136.455 475.995 131.667C478.228 126.463 480.092 121.108 481.574 115.642C482.514 112.533 482.946 110.475 482.946 110.475L497.713 97.7471H533.042C532.628 103.703 534.188 107.817 536.057 108.183C537.926 108.55 539.768 105.346 540.181 104.661Z"
    fill="black"
    opacity="0.1"
  />
  <path
    d="M544.53 112.213C544.324 119.897 540.998 127.365 536.32 131.846C535.242 132.734 534.228 133.698 533.286 134.73C530.89 137.732 529.277 141.283 528.589 145.062C526.945 143.089 525.93 140.668 525.677 138.111C525.433 134.213 527.105 127.027 527.19 126.022C527.19 126.022 527.19 125.749 527.274 125.43C527.274 124.876 527.359 124.65 527.434 123.786C527.564 121.91 527.564 120.026 527.434 118.15C527.455 118.06 527.455 117.967 527.434 117.877C518.491 123.326 493.007 136.599 475.854 123.514C473.188 121.482 470.828 119.078 468.846 116.375C468.641 116.159 468.473 115.912 468.349 115.642C467.865 114.969 467.426 114.267 467.033 113.538C466.996 113.476 466.955 113.416 466.911 113.359V113.312C465.865 111.449 465.141 109.423 464.77 107.319L464.638 106.492C464.561 105.555 464.561 104.612 464.638 103.674C465.122 100.035 466.851 96.6762 469.532 94.1681C474.501 89.2271 481.838 86.2963 485.698 84.7746C500.728 78.7345 523.489 77.2597 536.424 90.8616C539.662 94.4155 542.023 98.678 543.319 103.308C544.136 106.205 544.544 109.203 544.53 112.213Z"
    fill="#232B41"
    class="tblr-illustrations-boy-girl-c"
  />
  <path
    d="M527.378 117.887C518.435 123.335 492.95 136.608 475.798 123.523C473.131 121.492 470.771 119.087 468.79 116.384C468.585 116.169 468.417 115.921 468.292 115.651C467.809 114.979 467.37 114.276 466.977 113.547C466.94 113.485 466.899 113.426 466.855 113.369V113.322C465.828 111.452 465.123 109.423 464.77 107.319C468.771 111.224 473.388 114.442 478.437 116.844C503.452 128.586 529.679 113.951 533.859 111.621L534.179 111.433C532.074 113.75 529.801 115.907 527.378 117.887Z"
    fill="black"
    opacity="0.3"
  />
  <path
    d="M543.657 336.39L536.311 514.22H521.873L501.893 376.83L488.178 514.22H477.479L458.213 336.39H543.657Z"
    fill="#0455A4"
    style="fill: #0455a4; fill: var(--tblr-illustrations-primary, var(--tblr-primary, #0455a4))"
  />
  <path
    d="M505.697 538.906L537.926 535.318C537.926 535.318 539.091 526.967 534.037 524.046C528.984 521.124 510.967 531.081 505.697 538.906ZM458.26 538.906L490.479 535.318C490.479 535.318 491.644 526.967 486.6 524.046C481.556 521.124 463.473 531.081 458.26 538.906ZM420.385 276.76C422.47 282.504 425.272 287.961 428.726 293.002C434.133 300.991 441.72 307.26 450.585 311.065C451.487 303.348 449.862 295.547 445.954 288.831C439.472 277.634 428.754 272.852 420.385 276.76Z"
    fill="#232B41"
    class="tblr-illustrations-boy-girl-c"
  />
  <path
    d="M513.447 185.699C505.434 193.674 497.788 196.624 491.964 197.694L491.024 197.864L478.165 187.756L513.447 185.699Z"
    fill="#E1E1E1"
  />
  <path
    d="M450.867 241.44C454.744 254.128 458.629 266.812 462.525 279.494C469.157 287.839 476.911 295.226 485.567 301.446C499.357 311.235 521.995 322.187 542.238 321.474C552.74 321.126 562.594 317.632 570.231 309.262C576.534 302.32 579.559 294.054 582.555 282.518C583.298 279.653 584.049 276.6 584.838 273.303C586.999 264.379 593.424 236.546 584.575 211.588C581.353 202.523 577.69 198.211 575.651 196.154C573.275 193.74 570.476 191.782 567.394 190.377C564.57 189.104 561.548 188.323 558.461 188.066C558.301 188.93 558.085 190.18 557.841 191.683C557.08 196.379 556.592 200.362 556.282 203.105C556.188 203.979 556.037 205.35 555.887 207.013C555.53 210.77 555.27 214.393 555.107 217.881C555.029 225.279 553.997 232.635 552.036 239.768C550.243 246.356 547.577 252.675 544.108 258.555C535.992 262.148 527.347 264.4 518.51 265.225C486.168 268.165 461.285 250.148 450.867 241.44Z"
    fill="#DADBE0"
  />
  <path
    d="M542.238 321.492C552.74 321.145 562.594 317.65 570.231 309.281C576.534 302.339 579.558 294.073 582.555 282.537C575.547 283.683 567.469 287.741 559.898 294.458C550.861 302.433 544.586 312.475 542.238 321.492Z"
    fill="#232B41"
    class="tblr-illustrations-boy-girl-c"
  />
  <path
    d="M488.178 514.22L501.893 376.83L495.778 336.39H458.213L477.479 514.22H488.178Z"
    fill="black"
    opacity="0.22"
  />
  <path
    d="M494.801 195.468L473.956 180.495L469.194 185.539L483.359 206.694L494.801 195.468ZM495.778 195.318L527.368 175.629L534.582 182.261L513.118 210.075L495.778 195.318Z"
    fill="#0455A4"
    style="fill: #0455a4; fill: var(--tblr-illustrations-primary, var(--tblr-primary, #0455a4))"
  />
  <path
    d="M494.801 195.468L473.956 180.495L469.194 185.539L483.359 206.694L494.801 195.468Z"
    fill="black"
    opacity="0.22"
  />
</svg>
<div>
  <div class="text-center">
    <label class="form-check form-check-inline">
      <input class="form-check-input" type="radio" name="theme" value="light" checked />
      <span class="form-check-label">Light</span>
    </label>
    <label class="form-check form-check-inline">
      <input class="form-check-input" type="radio" name="theme" value="dark" />
      <span class="form-check-label">Dark</span>
    </label>
  </div>
</div>
<script>
  const toggleTheme = (theme) => {
    if (theme === "dark") {
      document.documentElement.setAttribute("data-bs-theme", "dark");
    } else {
      document.documentElement.setAttribute("data-bs-theme", "light");
    }
  };
  document.querySelectorAll(".form-check-input").forEach((input) => {
    input.addEventListener("change", (e) => {
      console.log(e.target.value);
      toggleTheme(e.target.value);
    });
  });
</script>
{%- endcapture %}
{% include "docs/example.html" html=html %}